package zio.aws.appsync.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ApiKey(
    id: Optional[String] = Optional.Absent,
    description: Optional[String] = Optional.Absent,
    expires: Optional[Long] = Optional.Absent,
    deletes: Optional[Long] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.appsync.model.ApiKey = {
    import ApiKey.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appsync.model.ApiKey
      .builder()
      .optionallyWith(id.map(value => value: java.lang.String))(_.id)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(expires.map(value => value: java.lang.Long))(_.expires)
      .optionallyWith(deletes.map(value => value: java.lang.Long))(_.deletes)
      .build()
  }
  def asReadOnly: zio.aws.appsync.model.ApiKey.ReadOnly =
    zio.aws.appsync.model.ApiKey.wrap(buildAwsValue())
}
object ApiKey {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.appsync.model.ApiKey] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appsync.model.ApiKey = zio.aws.appsync.model.ApiKey(
      id.map(value => value),
      description.map(value => value),
      expires.map(value => value),
      deletes.map(value => value)
    )
    def id: Optional[String]
    def description: Optional[String]
    def expires: Optional[Long]
    def deletes: Optional[Long]
    def getId: ZIO[Any, AwsError, String] = AwsError.unwrapOptionField("id", id)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getExpires: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("expires", expires)
    def getDeletes: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("deletes", deletes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appsync.model.ApiKey
  ) extends zio.aws.appsync.model.ApiKey.ReadOnly {
    override val id: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => value: String)
    override val description: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => value: String)
    override val expires: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.expires())
      .map(value => value: Long)
    override val deletes: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.deletes())
      .map(value => value: Long)
  }
  def wrap(
      impl: software.amazon.awssdk.services.appsync.model.ApiKey
  ): zio.aws.appsync.model.ApiKey.ReadOnly = new Wrapper(impl)
}
