package zio.aws.appsync.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteApiKeyRequest(apiId: String, id: String) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appsync.model.DeleteApiKeyRequest = {
    import DeleteApiKeyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appsync.model.DeleteApiKeyRequest
      .builder()
      .apiId(apiId: java.lang.String)
      .id(id: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.appsync.model.DeleteApiKeyRequest.ReadOnly =
    zio.aws.appsync.model.DeleteApiKeyRequest.wrap(buildAwsValue())
}
object DeleteApiKeyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appsync.model.DeleteApiKeyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appsync.model.DeleteApiKeyRequest =
      zio.aws.appsync.model.DeleteApiKeyRequest(apiId, id)
    def apiId: String
    def id: String
    def getApiId: ZIO[Any, Nothing, String] = ZIO.succeed(apiId)
    def getId: ZIO[Any, Nothing, String] = ZIO.succeed(id)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appsync.model.DeleteApiKeyRequest
  ) extends zio.aws.appsync.model.DeleteApiKeyRequest.ReadOnly {
    override val apiId: String = impl.apiId(): String
    override val id: String = impl.id(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.appsync.model.DeleteApiKeyRequest
  ): zio.aws.appsync.model.DeleteApiKeyRequest.ReadOnly = new Wrapper(impl)
}
