package zio.aws.appsync.model
import scala.jdk.CollectionConverters._
sealed trait AuthenticationType {
  def unwrap: software.amazon.awssdk.services.appsync.model.AuthenticationType
}
object AuthenticationType {
  def wrap(
      value: software.amazon.awssdk.services.appsync.model.AuthenticationType
  ): zio.aws.appsync.model.AuthenticationType = value match {
    case software.amazon.awssdk.services.appsync.model.AuthenticationType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.appsync.model.AuthenticationType.API_KEY =>
      val r = API_KEY
      r
    case software.amazon.awssdk.services.appsync.model.AuthenticationType.AWS_IAM =>
      val r = AWS_IAM
      r
    case software.amazon.awssdk.services.appsync.model.AuthenticationType.AMAZON_COGNITO_USER_POOLS =>
      val r = AMAZON_COGNITO_USER_POOLS
      r
    case software.amazon.awssdk.services.appsync.model.AuthenticationType.OPENID_CONNECT =>
      val r = OPENID_CONNECT
      r
    case software.amazon.awssdk.services.appsync.model.AuthenticationType.AWS_LAMBDA =>
      val r = AWS_LAMBDA
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.appsync.model.AuthenticationType {
    override def unwrap
        : software.amazon.awssdk.services.appsync.model.AuthenticationType =
      software.amazon.awssdk.services.appsync.model.AuthenticationType.UNKNOWN_TO_SDK_VERSION
  }
  case object API_KEY extends zio.aws.appsync.model.AuthenticationType {
    override def unwrap
        : software.amazon.awssdk.services.appsync.model.AuthenticationType =
      software.amazon.awssdk.services.appsync.model.AuthenticationType.API_KEY
  }
  case object AWS_IAM extends zio.aws.appsync.model.AuthenticationType {
    override def unwrap
        : software.amazon.awssdk.services.appsync.model.AuthenticationType =
      software.amazon.awssdk.services.appsync.model.AuthenticationType.AWS_IAM
  }
  case object AMAZON_COGNITO_USER_POOLS
      extends zio.aws.appsync.model.AuthenticationType {
    override def unwrap
        : software.amazon.awssdk.services.appsync.model.AuthenticationType =
      software.amazon.awssdk.services.appsync.model.AuthenticationType.AMAZON_COGNITO_USER_POOLS
  }
  case object OPENID_CONNECT extends zio.aws.appsync.model.AuthenticationType {
    override def unwrap
        : software.amazon.awssdk.services.appsync.model.AuthenticationType =
      software.amazon.awssdk.services.appsync.model.AuthenticationType.OPENID_CONNECT
  }
  case object AWS_LAMBDA extends zio.aws.appsync.model.AuthenticationType {
    override def unwrap
        : software.amazon.awssdk.services.appsync.model.AuthenticationType =
      software.amazon.awssdk.services.appsync.model.AuthenticationType.AWS_LAMBDA
  }
}
