package zio.aws.appsync.model
import zio.aws.appsync.model.primitives.DomainName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetApiAssociationRequest(domainName: DomainName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appsync.model.GetApiAssociationRequest = {
    import GetApiAssociationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appsync.model.GetApiAssociationRequest
      .builder()
      .domainName(DomainName.unwrap(domainName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.appsync.model.GetApiAssociationRequest.ReadOnly =
    zio.aws.appsync.model.GetApiAssociationRequest.wrap(buildAwsValue())
}
object GetApiAssociationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appsync.model.GetApiAssociationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appsync.model.GetApiAssociationRequest =
      zio.aws.appsync.model.GetApiAssociationRequest(domainName)
    def domainName: DomainName
    def getDomainName: ZIO[Any, Nothing, DomainName] = ZIO.succeed(domainName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appsync.model.GetApiAssociationRequest
  ) extends zio.aws.appsync.model.GetApiAssociationRequest.ReadOnly {
    override val domainName: DomainName =
      zio.aws.appsync.model.primitives.DomainName(impl.domainName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.appsync.model.GetApiAssociationRequest
  ): zio.aws.appsync.model.GetApiAssociationRequest.ReadOnly = new Wrapper(impl)
}
