package zio.aws.appsync.model
import scala.jdk.CollectionConverters._
sealed trait ApiCacheType {
  def unwrap: software.amazon.awssdk.services.appsync.model.ApiCacheType
}
object ApiCacheType {
  def wrap(
      value: software.amazon.awssdk.services.appsync.model.ApiCacheType
  ): zio.aws.appsync.model.ApiCacheType = value match {
    case software.amazon.awssdk.services.appsync.model.ApiCacheType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.appsync.model.ApiCacheType.T2_SMALL =>
      val r = T2_SMALL
      r
    case software.amazon.awssdk.services.appsync.model.ApiCacheType.T2_MEDIUM =>
      val r = T2_MEDIUM
      r
    case software.amazon.awssdk.services.appsync.model.ApiCacheType.R4_LARGE =>
      val r = R4_LARGE
      r
    case software.amazon.awssdk.services.appsync.model.ApiCacheType.R4_XLARGE =>
      val r = R4_XLARGE
      r
    case software.amazon.awssdk.services.appsync.model.ApiCacheType.R4_2_XLARGE =>
      val r = R4_2XLARGE
      r
    case software.amazon.awssdk.services.appsync.model.ApiCacheType.R4_4_XLARGE =>
      val r = R4_4XLARGE
      r
    case software.amazon.awssdk.services.appsync.model.ApiCacheType.R4_8_XLARGE =>
      val r = R4_8XLARGE
      r
    case software.amazon.awssdk.services.appsync.model.ApiCacheType.SMALL =>
      val r = SMALL
      r
    case software.amazon.awssdk.services.appsync.model.ApiCacheType.MEDIUM =>
      val r = MEDIUM
      r
    case software.amazon.awssdk.services.appsync.model.ApiCacheType.LARGE =>
      val r = LARGE
      r
    case software.amazon.awssdk.services.appsync.model.ApiCacheType.XLARGE =>
      val r = XLARGE
      r
    case software.amazon.awssdk.services.appsync.model.ApiCacheType.LARGE_2_X =>
      val r = LARGE_2X
      r
    case software.amazon.awssdk.services.appsync.model.ApiCacheType.LARGE_4_X =>
      val r = LARGE_4X
      r
    case software.amazon.awssdk.services.appsync.model.ApiCacheType.LARGE_8_X =>
      val r = LARGE_8X
      r
    case software.amazon.awssdk.services.appsync.model.ApiCacheType.LARGE_12_X =>
      val r = LARGE_12X
      r
  }
  case object unknownToSdkVersion extends zio.aws.appsync.model.ApiCacheType {
    override def unwrap
        : software.amazon.awssdk.services.appsync.model.ApiCacheType =
      software.amazon.awssdk.services.appsync.model.ApiCacheType.UNKNOWN_TO_SDK_VERSION
  }
  case object T2_SMALL extends zio.aws.appsync.model.ApiCacheType {
    override def unwrap
        : software.amazon.awssdk.services.appsync.model.ApiCacheType =
      software.amazon.awssdk.services.appsync.model.ApiCacheType.T2_SMALL
  }
  case object T2_MEDIUM extends zio.aws.appsync.model.ApiCacheType {
    override def unwrap
        : software.amazon.awssdk.services.appsync.model.ApiCacheType =
      software.amazon.awssdk.services.appsync.model.ApiCacheType.T2_MEDIUM
  }
  case object R4_LARGE extends zio.aws.appsync.model.ApiCacheType {
    override def unwrap
        : software.amazon.awssdk.services.appsync.model.ApiCacheType =
      software.amazon.awssdk.services.appsync.model.ApiCacheType.R4_LARGE
  }
  case object R4_XLARGE extends zio.aws.appsync.model.ApiCacheType {
    override def unwrap
        : software.amazon.awssdk.services.appsync.model.ApiCacheType =
      software.amazon.awssdk.services.appsync.model.ApiCacheType.R4_XLARGE
  }
  case object R4_2XLARGE extends zio.aws.appsync.model.ApiCacheType {
    override def unwrap
        : software.amazon.awssdk.services.appsync.model.ApiCacheType =
      software.amazon.awssdk.services.appsync.model.ApiCacheType.R4_2_XLARGE
  }
  case object R4_4XLARGE extends zio.aws.appsync.model.ApiCacheType {
    override def unwrap
        : software.amazon.awssdk.services.appsync.model.ApiCacheType =
      software.amazon.awssdk.services.appsync.model.ApiCacheType.R4_4_XLARGE
  }
  case object R4_8XLARGE extends zio.aws.appsync.model.ApiCacheType {
    override def unwrap
        : software.amazon.awssdk.services.appsync.model.ApiCacheType =
      software.amazon.awssdk.services.appsync.model.ApiCacheType.R4_8_XLARGE
  }
  case object SMALL extends zio.aws.appsync.model.ApiCacheType {
    override def unwrap
        : software.amazon.awssdk.services.appsync.model.ApiCacheType =
      software.amazon.awssdk.services.appsync.model.ApiCacheType.SMALL
  }
  case object MEDIUM extends zio.aws.appsync.model.ApiCacheType {
    override def unwrap
        : software.amazon.awssdk.services.appsync.model.ApiCacheType =
      software.amazon.awssdk.services.appsync.model.ApiCacheType.MEDIUM
  }
  case object LARGE extends zio.aws.appsync.model.ApiCacheType {
    override def unwrap
        : software.amazon.awssdk.services.appsync.model.ApiCacheType =
      software.amazon.awssdk.services.appsync.model.ApiCacheType.LARGE
  }
  case object XLARGE extends zio.aws.appsync.model.ApiCacheType {
    override def unwrap
        : software.amazon.awssdk.services.appsync.model.ApiCacheType =
      software.amazon.awssdk.services.appsync.model.ApiCacheType.XLARGE
  }
  case object LARGE_2X extends zio.aws.appsync.model.ApiCacheType {
    override def unwrap
        : software.amazon.awssdk.services.appsync.model.ApiCacheType =
      software.amazon.awssdk.services.appsync.model.ApiCacheType.LARGE_2_X
  }
  case object LARGE_4X extends zio.aws.appsync.model.ApiCacheType {
    override def unwrap
        : software.amazon.awssdk.services.appsync.model.ApiCacheType =
      software.amazon.awssdk.services.appsync.model.ApiCacheType.LARGE_4_X
  }
  case object LARGE_8X extends zio.aws.appsync.model.ApiCacheType {
    override def unwrap
        : software.amazon.awssdk.services.appsync.model.ApiCacheType =
      software.amazon.awssdk.services.appsync.model.ApiCacheType.LARGE_8_X
  }
  case object LARGE_12X extends zio.aws.appsync.model.ApiCacheType {
    override def unwrap
        : software.amazon.awssdk.services.appsync.model.ApiCacheType =
      software.amazon.awssdk.services.appsync.model.ApiCacheType.LARGE_12_X
  }
}
