package zio.aws.appsync.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CachingConfig(
    ttl: Optional[Long] = Optional.Absent,
    cachingKeys: Optional[Iterable[String]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appsync.model.CachingConfig = {
    import CachingConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appsync.model.CachingConfig
      .builder()
      .optionallyWith(ttl.map(value => value: java.lang.Long))(_.ttl)
      .optionallyWith(
        cachingKeys.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.cachingKeys)
      .build()
  }
  def asReadOnly: zio.aws.appsync.model.CachingConfig.ReadOnly =
    zio.aws.appsync.model.CachingConfig.wrap(buildAwsValue())
}
object CachingConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appsync.model.CachingConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appsync.model.CachingConfig = zio.aws.appsync.model
      .CachingConfig(ttl.map(value => value), cachingKeys.map(value => value))
    def ttl: Optional[Long]
    def cachingKeys: Optional[List[String]]
    def getTtl: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("ttl", ttl)
    def getCachingKeys: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("cachingKeys", cachingKeys)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appsync.model.CachingConfig
  ) extends zio.aws.appsync.model.CachingConfig.ReadOnly {
    override val ttl: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.ttl())
      .map(value => value: Long)
    override val cachingKeys: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.cachingKeys())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.appsync.model.CachingConfig
  ): zio.aws.appsync.model.CachingConfig.ReadOnly = new Wrapper(impl)
}
