package zio.aws.appsync.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class OpenIDConnectConfig(
    issuer: String,
    clientId: Optional[String] = Optional.Absent,
    iatTTL: Optional[Long] = Optional.Absent,
    authTTL: Optional[Long] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appsync.model.OpenIDConnectConfig = {
    import OpenIDConnectConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appsync.model.OpenIDConnectConfig
      .builder()
      .issuer(issuer: java.lang.String)
      .optionallyWith(clientId.map(value => value: java.lang.String))(
        _.clientId
      )
      .optionallyWith(iatTTL.map(value => value: java.lang.Long))(_.iatTTL)
      .optionallyWith(authTTL.map(value => value: java.lang.Long))(_.authTTL)
      .build()
  }
  def asReadOnly: zio.aws.appsync.model.OpenIDConnectConfig.ReadOnly =
    zio.aws.appsync.model.OpenIDConnectConfig.wrap(buildAwsValue())
}
object OpenIDConnectConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appsync.model.OpenIDConnectConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appsync.model.OpenIDConnectConfig =
      zio.aws.appsync.model.OpenIDConnectConfig(
        issuer,
        clientId.map(value => value),
        iatTTL.map(value => value),
        authTTL.map(value => value)
      )
    def issuer: String
    def clientId: Optional[String]
    def iatTTL: Optional[Long]
    def authTTL: Optional[Long]
    def getIssuer: ZIO[Any, Nothing, String] = ZIO.succeed(issuer)
    def getClientId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clientId", clientId)
    def getIatTTL: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("iatTTL", iatTTL)
    def getAuthTTL: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("authTTL", authTTL)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appsync.model.OpenIDConnectConfig
  ) extends zio.aws.appsync.model.OpenIDConnectConfig.ReadOnly {
    override val issuer: String = impl.issuer(): String
    override val clientId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.clientId())
      .map(value => value: String)
    override val iatTTL: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.iatTTL())
      .map(value => value: Long)
    override val authTTL: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.authTTL())
      .map(value => value: Long)
  }
  def wrap(
      impl: software.amazon.awssdk.services.appsync.model.OpenIDConnectConfig
  ): zio.aws.appsync.model.OpenIDConnectConfig.ReadOnly = new Wrapper(impl)
}
