package zio.aws.appsync.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateDomainNameResponse(
    domainNameConfig: Optional[zio.aws.appsync.model.DomainNameConfig] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appsync.model.CreateDomainNameResponse = {
    import CreateDomainNameResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appsync.model.CreateDomainNameResponse
      .builder()
      .optionallyWith(domainNameConfig.map(value => value.buildAwsValue()))(
        _.domainNameConfig
      )
      .build()
  }
  def asReadOnly: zio.aws.appsync.model.CreateDomainNameResponse.ReadOnly =
    zio.aws.appsync.model.CreateDomainNameResponse.wrap(buildAwsValue())
}
object CreateDomainNameResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appsync.model.CreateDomainNameResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appsync.model.CreateDomainNameResponse =
      zio.aws.appsync.model.CreateDomainNameResponse(
        domainNameConfig.map(value => value.asEditable)
      )
    def domainNameConfig
        : Optional[zio.aws.appsync.model.DomainNameConfig.ReadOnly]
    def getDomainNameConfig
        : ZIO[Any, AwsError, zio.aws.appsync.model.DomainNameConfig.ReadOnly] =
      AwsError.unwrapOptionField("domainNameConfig", domainNameConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appsync.model.CreateDomainNameResponse
  ) extends zio.aws.appsync.model.CreateDomainNameResponse.ReadOnly {
    override val domainNameConfig
        : Optional[zio.aws.appsync.model.DomainNameConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.domainNameConfig())
        .map(value => zio.aws.appsync.model.DomainNameConfig.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appsync.model.CreateDomainNameResponse
  ): zio.aws.appsync.model.CreateDomainNameResponse.ReadOnly = new Wrapper(impl)
}
