package zio.aws.appsync.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class UpdateDomainNameResponse(
    domainNameConfig: Option[zio.aws.appsync.model.DomainNameConfig] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appsync.model.UpdateDomainNameResponse = {
    import UpdateDomainNameResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appsync.model.UpdateDomainNameResponse
      .builder()
      .optionallyWith(domainNameConfig.map(value => value.buildAwsValue()))(
        _.domainNameConfig
      )
      .build()
  }
  def asReadOnly: zio.aws.appsync.model.UpdateDomainNameResponse.ReadOnly =
    zio.aws.appsync.model.UpdateDomainNameResponse.wrap(buildAwsValue())
}
object UpdateDomainNameResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appsync.model.UpdateDomainNameResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appsync.model.UpdateDomainNameResponse =
      zio.aws.appsync.model.UpdateDomainNameResponse(
        domainNameConfig.map(value => value.asEditable)
      )
    def domainNameConfig
        : Option[zio.aws.appsync.model.DomainNameConfig.ReadOnly]
    def getDomainNameConfig
        : ZIO[Any, AwsError, zio.aws.appsync.model.DomainNameConfig.ReadOnly] =
      AwsError.unwrapOptionField("domainNameConfig", domainNameConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appsync.model.UpdateDomainNameResponse
  ) extends zio.aws.appsync.model.UpdateDomainNameResponse.ReadOnly {
    override val domainNameConfig
        : Option[zio.aws.appsync.model.DomainNameConfig.ReadOnly] = scala
      .Option(impl.domainNameConfig())
      .map(value => zio.aws.appsync.model.DomainNameConfig.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appsync.model.UpdateDomainNameResponse
  ): zio.aws.appsync.model.UpdateDomainNameResponse.ReadOnly = new Wrapper(impl)
}
