package zio.aws.appsync.model
import zio.aws.appsync.model.primitives.{
  Description,
  CertificateArn,
  DomainName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateDomainNameRequest(
    domainName: DomainName,
    certificateArn: CertificateArn,
    description: Option[Description] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appsync.model.CreateDomainNameRequest = {
    import CreateDomainNameRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appsync.model.CreateDomainNameRequest
      .builder()
      .domainName(DomainName.unwrap(domainName): java.lang.String)
      .certificateArn(CertificateArn.unwrap(certificateArn): java.lang.String)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .build()
  }
  def asReadOnly: zio.aws.appsync.model.CreateDomainNameRequest.ReadOnly =
    zio.aws.appsync.model.CreateDomainNameRequest.wrap(buildAwsValue())
}
object CreateDomainNameRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appsync.model.CreateDomainNameRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appsync.model.CreateDomainNameRequest =
      zio.aws.appsync.model.CreateDomainNameRequest(
        domainName,
        certificateArn,
        description.map(value => value)
      )
    def domainName: DomainName
    def certificateArn: CertificateArn
    def description: Option[Description]
    def getDomainName: ZIO[Any, Nothing, DomainName] = ZIO.succeed(domainName)
    def getCertificateArn: ZIO[Any, Nothing, CertificateArn] =
      ZIO.succeed(certificateArn)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appsync.model.CreateDomainNameRequest
  ) extends zio.aws.appsync.model.CreateDomainNameRequest.ReadOnly {
    override val domainName: DomainName =
      zio.aws.appsync.model.primitives.DomainName(impl.domainName())
    override val certificateArn: CertificateArn =
      zio.aws.appsync.model.primitives.CertificateArn(impl.certificateArn())
    override val description: Option[Description] = scala
      .Option(impl.description())
      .map(value => zio.aws.appsync.model.primitives.Description(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appsync.model.CreateDomainNameRequest
  ): zio.aws.appsync.model.CreateDomainNameRequest.ReadOnly = new Wrapper(impl)
}
