package zio.aws.appsync.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class SyncConfig(
    conflictHandler: Option[zio.aws.appsync.model.ConflictHandlerType] = None,
    conflictDetection: Option[zio.aws.appsync.model.ConflictDetectionType] =
      None,
    lambdaConflictHandlerConfig: Option[
      zio.aws.appsync.model.LambdaConflictHandlerConfig
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appsync.model.SyncConfig = {
    import SyncConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appsync.model.SyncConfig
      .builder()
      .optionallyWith(conflictHandler.map(value => value.unwrap))(
        _.conflictHandler
      )
      .optionallyWith(conflictDetection.map(value => value.unwrap))(
        _.conflictDetection
      )
      .optionallyWith(
        lambdaConflictHandlerConfig.map(value => value.buildAwsValue())
      )(_.lambdaConflictHandlerConfig)
      .build()
  }
  def asReadOnly: zio.aws.appsync.model.SyncConfig.ReadOnly =
    zio.aws.appsync.model.SyncConfig.wrap(buildAwsValue())
}
object SyncConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appsync.model.SyncConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appsync.model.SyncConfig =
      zio.aws.appsync.model.SyncConfig(
        conflictHandler.map(value => value),
        conflictDetection.map(value => value),
        lambdaConflictHandlerConfig.map(value => value.asEditable)
      )
    def conflictHandler: Option[zio.aws.appsync.model.ConflictHandlerType]
    def conflictDetection: Option[zio.aws.appsync.model.ConflictDetectionType]
    def lambdaConflictHandlerConfig
        : Option[zio.aws.appsync.model.LambdaConflictHandlerConfig.ReadOnly]
    def getConflictHandler
        : ZIO[Any, AwsError, zio.aws.appsync.model.ConflictHandlerType] =
      AwsError.unwrapOptionField("conflictHandler", conflictHandler)
    def getConflictDetection
        : ZIO[Any, AwsError, zio.aws.appsync.model.ConflictDetectionType] =
      AwsError.unwrapOptionField("conflictDetection", conflictDetection)
    def getLambdaConflictHandlerConfig: ZIO[
      Any,
      AwsError,
      zio.aws.appsync.model.LambdaConflictHandlerConfig.ReadOnly
    ] = AwsError.unwrapOptionField(
      "lambdaConflictHandlerConfig",
      lambdaConflictHandlerConfig
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appsync.model.SyncConfig
  ) extends zio.aws.appsync.model.SyncConfig.ReadOnly {
    override val conflictHandler
        : Option[zio.aws.appsync.model.ConflictHandlerType] = scala
      .Option(impl.conflictHandler())
      .map(value => zio.aws.appsync.model.ConflictHandlerType.wrap(value))
    override val conflictDetection
        : Option[zio.aws.appsync.model.ConflictDetectionType] = scala
      .Option(impl.conflictDetection())
      .map(value => zio.aws.appsync.model.ConflictDetectionType.wrap(value))
    override val lambdaConflictHandlerConfig
        : Option[zio.aws.appsync.model.LambdaConflictHandlerConfig.ReadOnly] =
      scala
        .Option(impl.lambdaConflictHandlerConfig())
        .map(value =>
          zio.aws.appsync.model.LambdaConflictHandlerConfig.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.appsync.model.SyncConfig
  ): zio.aws.appsync.model.SyncConfig.ReadOnly = new Wrapper(impl)
}
