package zio.aws.appsync.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetResolverResponse(
    resolver: Option[zio.aws.appsync.model.Resolver] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appsync.model.GetResolverResponse = {
    import GetResolverResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appsync.model.GetResolverResponse
      .builder()
      .optionallyWith(resolver.map(value => value.buildAwsValue()))(_.resolver)
      .build()
  }
  def asReadOnly: zio.aws.appsync.model.GetResolverResponse.ReadOnly =
    zio.aws.appsync.model.GetResolverResponse.wrap(buildAwsValue())
}
object GetResolverResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appsync.model.GetResolverResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appsync.model.GetResolverResponse =
      zio.aws.appsync.model
        .GetResolverResponse(resolver.map(value => value.asEditable))
    def resolver: Option[zio.aws.appsync.model.Resolver.ReadOnly]
    def getResolver
        : ZIO[Any, AwsError, zio.aws.appsync.model.Resolver.ReadOnly] =
      AwsError.unwrapOptionField("resolver", resolver)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appsync.model.GetResolverResponse
  ) extends zio.aws.appsync.model.GetResolverResponse.ReadOnly {
    override val resolver: Option[zio.aws.appsync.model.Resolver.ReadOnly] =
      scala
        .Option(impl.resolver())
        .map(value => zio.aws.appsync.model.Resolver.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appsync.model.GetResolverResponse
  ): zio.aws.appsync.model.GetResolverResponse.ReadOnly = new Wrapper(impl)
}
