package zio.aws.appsync.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateFunctionResponse(
    functionConfiguration: Option[zio.aws.appsync.model.FunctionConfiguration] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appsync.model.CreateFunctionResponse = {
    import CreateFunctionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appsync.model.CreateFunctionResponse
      .builder()
      .optionallyWith(
        functionConfiguration.map(value => value.buildAwsValue())
      )(_.functionConfiguration)
      .build()
  }
  def asReadOnly: zio.aws.appsync.model.CreateFunctionResponse.ReadOnly =
    zio.aws.appsync.model.CreateFunctionResponse.wrap(buildAwsValue())
}
object CreateFunctionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appsync.model.CreateFunctionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appsync.model.CreateFunctionResponse =
      zio.aws.appsync.model.CreateFunctionResponse(
        functionConfiguration.map(value => value.asEditable)
      )
    def functionConfiguration
        : Option[zio.aws.appsync.model.FunctionConfiguration.ReadOnly]
    def getFunctionConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.appsync.model.FunctionConfiguration.ReadOnly
    ] =
      AwsError.unwrapOptionField("functionConfiguration", functionConfiguration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appsync.model.CreateFunctionResponse
  ) extends zio.aws.appsync.model.CreateFunctionResponse.ReadOnly {
    override val functionConfiguration
        : Option[zio.aws.appsync.model.FunctionConfiguration.ReadOnly] = scala
      .Option(impl.functionConfiguration())
      .map(value => zio.aws.appsync.model.FunctionConfiguration.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appsync.model.CreateFunctionResponse
  ): zio.aws.appsync.model.CreateFunctionResponse.ReadOnly = new Wrapper(impl)
}
