package zio.aws.appsync.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AuthorizationConfig(
    authorizationType: zio.aws.appsync.model.AuthorizationType,
    awsIamConfig: Option[zio.aws.appsync.model.AwsIamConfig] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appsync.model.AuthorizationConfig = {
    import AuthorizationConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appsync.model.AuthorizationConfig
      .builder()
      .authorizationType(authorizationType.unwrap)
      .optionallyWith(awsIamConfig.map(value => value.buildAwsValue()))(
        _.awsIamConfig
      )
      .build()
  }
  def asReadOnly: zio.aws.appsync.model.AuthorizationConfig.ReadOnly =
    zio.aws.appsync.model.AuthorizationConfig.wrap(buildAwsValue())
}
object AuthorizationConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appsync.model.AuthorizationConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appsync.model.AuthorizationConfig =
      zio.aws.appsync.model.AuthorizationConfig(
        authorizationType,
        awsIamConfig.map(value => value.asEditable)
      )
    def authorizationType: zio.aws.appsync.model.AuthorizationType
    def awsIamConfig: Option[zio.aws.appsync.model.AwsIamConfig.ReadOnly]
    def getAuthorizationType
        : ZIO[Any, Nothing, zio.aws.appsync.model.AuthorizationType] =
      ZIO.succeed(authorizationType)
    def getAwsIamConfig
        : ZIO[Any, AwsError, zio.aws.appsync.model.AwsIamConfig.ReadOnly] =
      AwsError.unwrapOptionField("awsIamConfig", awsIamConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appsync.model.AuthorizationConfig
  ) extends zio.aws.appsync.model.AuthorizationConfig.ReadOnly {
    override val authorizationType: zio.aws.appsync.model.AuthorizationType =
      zio.aws.appsync.model.AuthorizationType.wrap(impl.authorizationType())
    override val awsIamConfig
        : Option[zio.aws.appsync.model.AwsIamConfig.ReadOnly] = scala
      .Option(impl.awsIamConfig())
      .map(value => zio.aws.appsync.model.AwsIamConfig.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appsync.model.AuthorizationConfig
  ): zio.aws.appsync.model.AuthorizationConfig.ReadOnly = new Wrapper(impl)
}
