package zio.aws.appsync.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class LambdaDataSourceConfig(lambdaFunctionArn: String) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appsync.model.LambdaDataSourceConfig = {
    import LambdaDataSourceConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appsync.model.LambdaDataSourceConfig
      .builder()
      .lambdaFunctionArn(lambdaFunctionArn: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.appsync.model.LambdaDataSourceConfig.ReadOnly =
    zio.aws.appsync.model.LambdaDataSourceConfig.wrap(buildAwsValue())
}
object LambdaDataSourceConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appsync.model.LambdaDataSourceConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appsync.model.LambdaDataSourceConfig =
      zio.aws.appsync.model.LambdaDataSourceConfig(lambdaFunctionArn)
    def lambdaFunctionArn: String
    def getLambdaFunctionArn: ZIO[Any, Nothing, String] =
      ZIO.succeed(lambdaFunctionArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appsync.model.LambdaDataSourceConfig
  ) extends zio.aws.appsync.model.LambdaDataSourceConfig.ReadOnly {
    override val lambdaFunctionArn: String = impl.lambdaFunctionArn(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.appsync.model.LambdaDataSourceConfig
  ): zio.aws.appsync.model.LambdaDataSourceConfig.ReadOnly = new Wrapper(impl)
}
