package zio.aws.appsync.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class PipelineConfig(functions: Option[Iterable[String]] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appsync.model.PipelineConfig = {
    import PipelineConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appsync.model.PipelineConfig
      .builder()
      .optionallyWith(
        functions.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.functions)
      .build()
  }
  def asReadOnly: zio.aws.appsync.model.PipelineConfig.ReadOnly =
    zio.aws.appsync.model.PipelineConfig.wrap(buildAwsValue())
}
object PipelineConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appsync.model.PipelineConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appsync.model.PipelineConfig =
      zio.aws.appsync.model.PipelineConfig(functions.map(value => value))
    def functions: Option[List[String]]
    def getFunctions: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("functions", functions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appsync.model.PipelineConfig
  ) extends zio.aws.appsync.model.PipelineConfig.ReadOnly {
    override val functions: Option[List[String]] = scala
      .Option(impl.functions())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.appsync.model.PipelineConfig
  ): zio.aws.appsync.model.PipelineConfig.ReadOnly = new Wrapper(impl)
}
