package zio.aws.appsync.model
import zio.aws.appsync.model.primitives.PaginationToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListDataSourcesResponse(
    dataSources: Option[Iterable[zio.aws.appsync.model.DataSource]] = None,
    nextToken: Option[PaginationToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appsync.model.ListDataSourcesResponse = {
    import ListDataSourcesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appsync.model.ListDataSourcesResponse
      .builder()
      .optionallyWith(
        dataSources.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.dataSources)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.appsync.model.ListDataSourcesResponse.ReadOnly =
    zio.aws.appsync.model.ListDataSourcesResponse.wrap(buildAwsValue())
}
object ListDataSourcesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appsync.model.ListDataSourcesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appsync.model.ListDataSourcesResponse =
      zio.aws.appsync.model.ListDataSourcesResponse(
        dataSources.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def dataSources: Option[List[zio.aws.appsync.model.DataSource.ReadOnly]]
    def nextToken: Option[PaginationToken]
    def getDataSources
        : ZIO[Any, AwsError, List[zio.aws.appsync.model.DataSource.ReadOnly]] =
      AwsError.unwrapOptionField("dataSources", dataSources)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appsync.model.ListDataSourcesResponse
  ) extends zio.aws.appsync.model.ListDataSourcesResponse.ReadOnly {
    override val dataSources
        : Option[List[zio.aws.appsync.model.DataSource.ReadOnly]] = scala
      .Option(impl.dataSources())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.appsync.model.DataSource.wrap(item)
        }.toList
      )
    override val nextToken: Option[PaginationToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.appsync.model.primitives.PaginationToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appsync.model.ListDataSourcesResponse
  ): zio.aws.appsync.model.ListDataSourcesResponse.ReadOnly = new Wrapper(impl)
}
