package zio.aws.appsync.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetSchemaCreationStatusResponse(
    status: Option[zio.aws.appsync.model.SchemaStatus] = None,
    details: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appsync.model.GetSchemaCreationStatusResponse = {
    import GetSchemaCreationStatusResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appsync.model.GetSchemaCreationStatusResponse
      .builder()
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(details.map(value => value: java.lang.String))(_.details)
      .build()
  }
  def asReadOnly
      : zio.aws.appsync.model.GetSchemaCreationStatusResponse.ReadOnly =
    zio.aws.appsync.model.GetSchemaCreationStatusResponse.wrap(buildAwsValue())
}
object GetSchemaCreationStatusResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appsync.model.GetSchemaCreationStatusResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appsync.model.GetSchemaCreationStatusResponse =
      zio.aws.appsync.model.GetSchemaCreationStatusResponse(
        status.map(value => value),
        details.map(value => value)
      )
    def status: Option[zio.aws.appsync.model.SchemaStatus]
    def details: Option[String]
    def getStatus: ZIO[Any, AwsError, zio.aws.appsync.model.SchemaStatus] =
      AwsError.unwrapOptionField("status", status)
    def getDetails: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("details", details)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appsync.model.GetSchemaCreationStatusResponse
  ) extends zio.aws.appsync.model.GetSchemaCreationStatusResponse.ReadOnly {
    override val status: Option[zio.aws.appsync.model.SchemaStatus] = scala
      .Option(impl.status())
      .map(value => zio.aws.appsync.model.SchemaStatus.wrap(value))
    override val details: Option[String] =
      scala.Option(impl.details()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.appsync.model.GetSchemaCreationStatusResponse
  ): zio.aws.appsync.model.GetSchemaCreationStatusResponse.ReadOnly =
    new Wrapper(impl)
}
