package zio.aws.appsync.model
import java.lang.Integer
import zio.aws.appsync.model.primitives.{
  MaxBatchSize,
  MappingTemplate,
  ResourceName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateFunctionRequest(
    apiId: String,
    name: ResourceName,
    description: Option[String] = None,
    dataSourceName: ResourceName,
    requestMappingTemplate: Option[MappingTemplate] = None,
    responseMappingTemplate: Option[MappingTemplate] = None,
    functionVersion: String,
    syncConfig: Option[zio.aws.appsync.model.SyncConfig] = None,
    maxBatchSize: Option[MaxBatchSize] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appsync.model.CreateFunctionRequest = {
    import CreateFunctionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appsync.model.CreateFunctionRequest
      .builder()
      .apiId(apiId: java.lang.String)
      .name(ResourceName.unwrap(name): java.lang.String)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .dataSourceName(ResourceName.unwrap(dataSourceName): java.lang.String)
      .optionallyWith(
        requestMappingTemplate.map(value =>
          MappingTemplate.unwrap(value): java.lang.String
        )
      )(_.requestMappingTemplate)
      .optionallyWith(
        responseMappingTemplate.map(value =>
          MappingTemplate.unwrap(value): java.lang.String
        )
      )(_.responseMappingTemplate)
      .functionVersion(functionVersion: java.lang.String)
      .optionallyWith(syncConfig.map(value => value.buildAwsValue()))(
        _.syncConfig
      )
      .optionallyWith(
        maxBatchSize.map(value => MaxBatchSize.unwrap(value): Integer)
      )(_.maxBatchSize)
      .build()
  }
  def asReadOnly: zio.aws.appsync.model.CreateFunctionRequest.ReadOnly =
    zio.aws.appsync.model.CreateFunctionRequest.wrap(buildAwsValue())
}
object CreateFunctionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appsync.model.CreateFunctionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appsync.model.CreateFunctionRequest =
      zio.aws.appsync.model.CreateFunctionRequest(
        apiId,
        name,
        description.map(value => value),
        dataSourceName,
        requestMappingTemplate.map(value => value),
        responseMappingTemplate.map(value => value),
        functionVersion,
        syncConfig.map(value => value.asEditable),
        maxBatchSize.map(value => value)
      )
    def apiId: String
    def name: ResourceName
    def description: Option[String]
    def dataSourceName: ResourceName
    def requestMappingTemplate: Option[MappingTemplate]
    def responseMappingTemplate: Option[MappingTemplate]
    def functionVersion: String
    def syncConfig: Option[zio.aws.appsync.model.SyncConfig.ReadOnly]
    def maxBatchSize: Option[MaxBatchSize]
    def getApiId: ZIO[Any, Nothing, String] = ZIO.succeed(apiId)
    def getName: ZIO[Any, Nothing, ResourceName] = ZIO.succeed(name)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getDataSourceName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(dataSourceName)
    def getRequestMappingTemplate: ZIO[Any, AwsError, MappingTemplate] =
      AwsError.unwrapOptionField(
        "requestMappingTemplate",
        requestMappingTemplate
      )
    def getResponseMappingTemplate: ZIO[Any, AwsError, MappingTemplate] =
      AwsError.unwrapOptionField(
        "responseMappingTemplate",
        responseMappingTemplate
      )
    def getFunctionVersion: ZIO[Any, Nothing, String] =
      ZIO.succeed(functionVersion)
    def getSyncConfig
        : ZIO[Any, AwsError, zio.aws.appsync.model.SyncConfig.ReadOnly] =
      AwsError.unwrapOptionField("syncConfig", syncConfig)
    def getMaxBatchSize: ZIO[Any, AwsError, MaxBatchSize] =
      AwsError.unwrapOptionField("maxBatchSize", maxBatchSize)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appsync.model.CreateFunctionRequest
  ) extends zio.aws.appsync.model.CreateFunctionRequest.ReadOnly {
    override val apiId: String = impl.apiId(): String
    override val name: ResourceName =
      zio.aws.appsync.model.primitives.ResourceName(impl.name())
    override val description: Option[String] =
      scala.Option(impl.description()).map(value => value: String)
    override val dataSourceName: ResourceName =
      zio.aws.appsync.model.primitives.ResourceName(impl.dataSourceName())
    override val requestMappingTemplate: Option[MappingTemplate] = scala
      .Option(impl.requestMappingTemplate())
      .map(value => zio.aws.appsync.model.primitives.MappingTemplate(value))
    override val responseMappingTemplate: Option[MappingTemplate] = scala
      .Option(impl.responseMappingTemplate())
      .map(value => zio.aws.appsync.model.primitives.MappingTemplate(value))
    override val functionVersion: String = impl.functionVersion(): String
    override val syncConfig: Option[zio.aws.appsync.model.SyncConfig.ReadOnly] =
      scala
        .Option(impl.syncConfig())
        .map(value => zio.aws.appsync.model.SyncConfig.wrap(value))
    override val maxBatchSize: Option[MaxBatchSize] = scala
      .Option(impl.maxBatchSize())
      .map(value => zio.aws.appsync.model.primitives.MaxBatchSize(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appsync.model.CreateFunctionRequest
  ): zio.aws.appsync.model.CreateFunctionRequest.ReadOnly = new Wrapper(impl)
}
