package zio.aws.appsync.model
import java.lang.Integer
import zio.aws.appsync.model.primitives.{MaxResults, PaginationToken}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListApiKeysRequest(
    apiId: String,
    nextToken: Option[PaginationToken] = None,
    maxResults: Option[MaxResults] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appsync.model.ListApiKeysRequest = {
    import ListApiKeysRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appsync.model.ListApiKeysRequest
      .builder()
      .apiId(apiId: java.lang.String)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.appsync.model.ListApiKeysRequest.ReadOnly =
    zio.aws.appsync.model.ListApiKeysRequest.wrap(buildAwsValue())
}
object ListApiKeysRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appsync.model.ListApiKeysRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appsync.model.ListApiKeysRequest =
      zio.aws.appsync.model.ListApiKeysRequest(
        apiId,
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def apiId: String
    def nextToken: Option[PaginationToken]
    def maxResults: Option[MaxResults]
    def getApiId: ZIO[Any, Nothing, String] = ZIO.succeed(apiId)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appsync.model.ListApiKeysRequest
  ) extends zio.aws.appsync.model.ListApiKeysRequest.ReadOnly {
    override val apiId: String = impl.apiId(): String
    override val nextToken: Option[PaginationToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.appsync.model.primitives.PaginationToken(value))
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.appsync.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appsync.model.ListApiKeysRequest
  ): zio.aws.appsync.model.ListApiKeysRequest.ReadOnly = new Wrapper(impl)
}
