package zio.aws.appsync.model
import zio.aws.appsync.model.primitives.PaginationToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListResolversByFunctionResponse(
    resolvers: Option[Iterable[zio.aws.appsync.model.Resolver]] = None,
    nextToken: Option[PaginationToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appsync.model.ListResolversByFunctionResponse = {
    import ListResolversByFunctionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appsync.model.ListResolversByFunctionResponse
      .builder()
      .optionallyWith(
        resolvers.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.resolvers)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.appsync.model.ListResolversByFunctionResponse.ReadOnly =
    zio.aws.appsync.model.ListResolversByFunctionResponse.wrap(buildAwsValue())
}
object ListResolversByFunctionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appsync.model.ListResolversByFunctionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appsync.model.ListResolversByFunctionResponse =
      zio.aws.appsync.model.ListResolversByFunctionResponse(
        resolvers.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def resolvers: Option[List[zio.aws.appsync.model.Resolver.ReadOnly]]
    def nextToken: Option[PaginationToken]
    def getResolvers
        : ZIO[Any, AwsError, List[zio.aws.appsync.model.Resolver.ReadOnly]] =
      AwsError.unwrapOptionField("resolvers", resolvers)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appsync.model.ListResolversByFunctionResponse
  ) extends zio.aws.appsync.model.ListResolversByFunctionResponse.ReadOnly {
    override val resolvers
        : Option[List[zio.aws.appsync.model.Resolver.ReadOnly]] = scala
      .Option(impl.resolvers())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.appsync.model.Resolver.wrap(item)
        }.toList
      )
    override val nextToken: Option[PaginationToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.appsync.model.primitives.PaginationToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appsync.model.ListResolversByFunctionResponse
  ): zio.aws.appsync.model.ListResolversByFunctionResponse.ReadOnly =
    new Wrapper(impl)
}
