package zio.aws.appsync.model
import zio.aws.appsync.model.primitives.PaginationToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListApiKeysResponse(
    apiKeys: Option[Iterable[zio.aws.appsync.model.ApiKey]] = None,
    nextToken: Option[PaginationToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appsync.model.ListApiKeysResponse = {
    import ListApiKeysResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appsync.model.ListApiKeysResponse
      .builder()
      .optionallyWith(
        apiKeys.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.apiKeys)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.appsync.model.ListApiKeysResponse.ReadOnly =
    zio.aws.appsync.model.ListApiKeysResponse.wrap(buildAwsValue())
}
object ListApiKeysResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appsync.model.ListApiKeysResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appsync.model.ListApiKeysResponse =
      zio.aws.appsync.model.ListApiKeysResponse(
        apiKeys.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def apiKeys: Option[List[zio.aws.appsync.model.ApiKey.ReadOnly]]
    def nextToken: Option[PaginationToken]
    def getApiKeys
        : ZIO[Any, AwsError, List[zio.aws.appsync.model.ApiKey.ReadOnly]] =
      AwsError.unwrapOptionField("apiKeys", apiKeys)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appsync.model.ListApiKeysResponse
  ) extends zio.aws.appsync.model.ListApiKeysResponse.ReadOnly {
    override val apiKeys: Option[List[zio.aws.appsync.model.ApiKey.ReadOnly]] =
      scala
        .Option(impl.apiKeys())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.appsync.model.ApiKey.wrap(item)
          }.toList
        )
    override val nextToken: Option[PaginationToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.appsync.model.primitives.PaginationToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appsync.model.ListApiKeysResponse
  ): zio.aws.appsync.model.ListApiKeysResponse.ReadOnly = new Wrapper(impl)
}
