package zio.aws.appsync.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateGraphqlApiResponse(
    graphqlApi: Option[zio.aws.appsync.model.GraphqlApi] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appsync.model.CreateGraphqlApiResponse = {
    import CreateGraphqlApiResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appsync.model.CreateGraphqlApiResponse
      .builder()
      .optionallyWith(graphqlApi.map(value => value.buildAwsValue()))(
        _.graphqlApi
      )
      .build()
  }
  def asReadOnly: zio.aws.appsync.model.CreateGraphqlApiResponse.ReadOnly =
    zio.aws.appsync.model.CreateGraphqlApiResponse.wrap(buildAwsValue())
}
object CreateGraphqlApiResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appsync.model.CreateGraphqlApiResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appsync.model.CreateGraphqlApiResponse =
      zio.aws.appsync.model
        .CreateGraphqlApiResponse(graphqlApi.map(value => value.asEditable))
    def graphqlApi: Option[zio.aws.appsync.model.GraphqlApi.ReadOnly]
    def getGraphqlApi
        : ZIO[Any, AwsError, zio.aws.appsync.model.GraphqlApi.ReadOnly] =
      AwsError.unwrapOptionField("graphqlApi", graphqlApi)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appsync.model.CreateGraphqlApiResponse
  ) extends zio.aws.appsync.model.CreateGraphqlApiResponse.ReadOnly {
    override val graphqlApi: Option[zio.aws.appsync.model.GraphqlApi.ReadOnly] =
      scala
        .Option(impl.graphqlApi())
        .map(value => zio.aws.appsync.model.GraphqlApi.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appsync.model.CreateGraphqlApiResponse
  ): zio.aws.appsync.model.CreateGraphqlApiResponse.ReadOnly = new Wrapper(impl)
}
