package zio.aws.appsync.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DeltaSyncConfig(
    baseTableTTL: Option[Long] = None,
    deltaSyncTableName: Option[String] = None,
    deltaSyncTableTTL: Option[Long] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appsync.model.DeltaSyncConfig = {
    import DeltaSyncConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appsync.model.DeltaSyncConfig
      .builder()
      .optionallyWith(baseTableTTL.map(value => value: java.lang.Long))(
        _.baseTableTTL
      )
      .optionallyWith(deltaSyncTableName.map(value => value: java.lang.String))(
        _.deltaSyncTableName
      )
      .optionallyWith(deltaSyncTableTTL.map(value => value: java.lang.Long))(
        _.deltaSyncTableTTL
      )
      .build()
  }
  def asReadOnly: zio.aws.appsync.model.DeltaSyncConfig.ReadOnly =
    zio.aws.appsync.model.DeltaSyncConfig.wrap(buildAwsValue())
}
object DeltaSyncConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appsync.model.DeltaSyncConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appsync.model.DeltaSyncConfig =
      zio.aws.appsync.model.DeltaSyncConfig(
        baseTableTTL.map(value => value),
        deltaSyncTableName.map(value => value),
        deltaSyncTableTTL.map(value => value)
      )
    def baseTableTTL: Option[Long]
    def deltaSyncTableName: Option[String]
    def deltaSyncTableTTL: Option[Long]
    def getBaseTableTTL: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("baseTableTTL", baseTableTTL)
    def getDeltaSyncTableName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("deltaSyncTableName", deltaSyncTableName)
    def getDeltaSyncTableTTL: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("deltaSyncTableTTL", deltaSyncTableTTL)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appsync.model.DeltaSyncConfig
  ) extends zio.aws.appsync.model.DeltaSyncConfig.ReadOnly {
    override val baseTableTTL: Option[Long] =
      scala.Option(impl.baseTableTTL()).map(value => value: Long)
    override val deltaSyncTableName: Option[String] =
      scala.Option(impl.deltaSyncTableName()).map(value => value: String)
    override val deltaSyncTableTTL: Option[Long] =
      scala.Option(impl.deltaSyncTableTTL()).map(value => value: Long)
  }
  def wrap(
      impl: software.amazon.awssdk.services.appsync.model.DeltaSyncConfig
  ): zio.aws.appsync.model.DeltaSyncConfig.ReadOnly = new Wrapper(impl)
}
