package zio.aws.appstream.model
import zio.ZIO
import zio.aws.appstream.model.primitives.Name
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class StartAppBlockBuilderRequest(name: Name) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appstream.model.StartAppBlockBuilderRequest = {
    import StartAppBlockBuilderRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appstream.model.StartAppBlockBuilderRequest
      .builder()
      .name(Name.unwrap(name): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.appstream.model.StartAppBlockBuilderRequest.ReadOnly =
    zio.aws.appstream.model.StartAppBlockBuilderRequest.wrap(buildAwsValue())
}
object StartAppBlockBuilderRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appstream.model.StartAppBlockBuilderRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appstream.model.StartAppBlockBuilderRequest =
      zio.aws.appstream.model.StartAppBlockBuilderRequest(name)
    def name: Name
    def getName: ZIO[Any, Nothing, Name] = ZIO.succeed(name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appstream.model.StartAppBlockBuilderRequest
  ) extends zio.aws.appstream.model.StartAppBlockBuilderRequest.ReadOnly {
    override val name: Name =
      zio.aws.appstream.model.primitives.Name(impl.name())
  }
  def wrap(
      impl: software.amazon.awssdk.services.appstream.model.StartAppBlockBuilderRequest
  ): zio.aws.appstream.model.StartAppBlockBuilderRequest.ReadOnly = new Wrapper(
    impl
  )
}
