package zio.aws.appstream.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.appstream.model.primitives.{Timestamp, UserId}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class Session(
    id: String,
    userId: UserId,
    stackName: String,
    fleetName: String,
    state: zio.aws.appstream.model.SessionState,
    connectionState: Optional[zio.aws.appstream.model.SessionConnectionState] =
      Optional.Absent,
    startTime: Optional[Timestamp] = Optional.Absent,
    maxExpirationTime: Optional[Timestamp] = Optional.Absent,
    authenticationType: Optional[zio.aws.appstream.model.AuthenticationType] =
      Optional.Absent,
    networkAccessConfiguration: Optional[
      zio.aws.appstream.model.NetworkAccessConfiguration
    ] = Optional.Absent,
    instanceId: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appstream.model.Session = {
    import Session.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appstream.model.Session
      .builder()
      .id(id: java.lang.String)
      .userId(UserId.unwrap(userId): java.lang.String)
      .stackName(stackName: java.lang.String)
      .fleetName(fleetName: java.lang.String)
      .state(state.unwrap)
      .optionallyWith(connectionState.map(value => value.unwrap))(
        _.connectionState
      )
      .optionallyWith(startTime.map(value => Timestamp.unwrap(value): Instant))(
        _.startTime
      )
      .optionallyWith(
        maxExpirationTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.maxExpirationTime)
      .optionallyWith(authenticationType.map(value => value.unwrap))(
        _.authenticationType
      )
      .optionallyWith(
        networkAccessConfiguration.map(value => value.buildAwsValue())
      )(_.networkAccessConfiguration)
      .optionallyWith(instanceId.map(value => value: java.lang.String))(
        _.instanceId
      )
      .build()
  }
  def asReadOnly: zio.aws.appstream.model.Session.ReadOnly =
    zio.aws.appstream.model.Session.wrap(buildAwsValue())
}
object Session {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.appstream.model.Session] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appstream.model.Session =
      zio.aws.appstream.model.Session(
        id,
        userId,
        stackName,
        fleetName,
        state,
        connectionState.map(value => value),
        startTime.map(value => value),
        maxExpirationTime.map(value => value),
        authenticationType.map(value => value),
        networkAccessConfiguration.map(value => value.asEditable),
        instanceId.map(value => value)
      )
    def id: String
    def userId: UserId
    def stackName: String
    def fleetName: String
    def state: zio.aws.appstream.model.SessionState
    def connectionState
        : Optional[zio.aws.appstream.model.SessionConnectionState]
    def startTime: Optional[Timestamp]
    def maxExpirationTime: Optional[Timestamp]
    def authenticationType: Optional[zio.aws.appstream.model.AuthenticationType]
    def networkAccessConfiguration
        : Optional[zio.aws.appstream.model.NetworkAccessConfiguration.ReadOnly]
    def instanceId: Optional[String]
    def getId: ZIO[Any, Nothing, String] = ZIO.succeed(id)
    def getUserId: ZIO[Any, Nothing, UserId] = ZIO.succeed(userId)
    def getStackName: ZIO[Any, Nothing, String] = ZIO.succeed(stackName)
    def getFleetName: ZIO[Any, Nothing, String] = ZIO.succeed(fleetName)
    def getState: ZIO[Any, Nothing, zio.aws.appstream.model.SessionState] =
      ZIO.succeed(state)
    def getConnectionState
        : ZIO[Any, AwsError, zio.aws.appstream.model.SessionConnectionState] =
      AwsError.unwrapOptionField("connectionState", connectionState)
    def getStartTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("startTime", startTime)
    def getMaxExpirationTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("maxExpirationTime", maxExpirationTime)
    def getAuthenticationType
        : ZIO[Any, AwsError, zio.aws.appstream.model.AuthenticationType] =
      AwsError.unwrapOptionField("authenticationType", authenticationType)
    def getNetworkAccessConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.appstream.model.NetworkAccessConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "networkAccessConfiguration",
      networkAccessConfiguration
    )
    def getInstanceId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("instanceId", instanceId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appstream.model.Session
  ) extends zio.aws.appstream.model.Session.ReadOnly {
    override val id: String = impl.id(): String
    override val userId: UserId =
      zio.aws.appstream.model.primitives.UserId(impl.userId())
    override val stackName: String = impl.stackName(): String
    override val fleetName: String = impl.fleetName(): String
    override val state: zio.aws.appstream.model.SessionState =
      zio.aws.appstream.model.SessionState.wrap(impl.state())
    override val connectionState
        : Optional[zio.aws.appstream.model.SessionConnectionState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.connectionState())
        .map(value =>
          zio.aws.appstream.model.SessionConnectionState.wrap(value)
        )
    override val startTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.startTime())
      .map(value => zio.aws.appstream.model.primitives.Timestamp(value))
    override val maxExpirationTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.maxExpirationTime())
      .map(value => zio.aws.appstream.model.primitives.Timestamp(value))
    override val authenticationType
        : Optional[zio.aws.appstream.model.AuthenticationType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.authenticationType())
        .map(value => zio.aws.appstream.model.AuthenticationType.wrap(value))
    override val networkAccessConfiguration: Optional[
      zio.aws.appstream.model.NetworkAccessConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.networkAccessConfiguration())
      .map(value =>
        zio.aws.appstream.model.NetworkAccessConfiguration.wrap(value)
      )
    override val instanceId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.instanceId())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.appstream.model.Session
  ): zio.aws.appstream.model.Session.ReadOnly = new Wrapper(impl)
}
