package zio.aws.appstream.model
import zio.ZIO
import zio.aws.appstream.model.primitives.{S3Key, S3Bucket}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class S3Location(
    s3Bucket: S3Bucket,
    s3Key: Optional[S3Key] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appstream.model.S3Location = {
    import S3Location.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appstream.model.S3Location
      .builder()
      .s3Bucket(S3Bucket.unwrap(s3Bucket): java.lang.String)
      .optionallyWith(
        s3Key.map(value => S3Key.unwrap(value): java.lang.String)
      )(_.s3Key)
      .build()
  }
  def asReadOnly: zio.aws.appstream.model.S3Location.ReadOnly =
    zio.aws.appstream.model.S3Location.wrap(buildAwsValue())
}
object S3Location {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appstream.model.S3Location
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appstream.model.S3Location =
      zio.aws.appstream.model.S3Location(s3Bucket, s3Key.map(value => value))
    def s3Bucket: S3Bucket
    def s3Key: Optional[S3Key]
    def getS3Bucket: ZIO[Any, Nothing, S3Bucket] = ZIO.succeed(s3Bucket)
    def getS3Key: ZIO[Any, AwsError, S3Key] =
      AwsError.unwrapOptionField("s3Key", s3Key)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appstream.model.S3Location
  ) extends zio.aws.appstream.model.S3Location.ReadOnly {
    override val s3Bucket: S3Bucket =
      zio.aws.appstream.model.primitives.S3Bucket(impl.s3Bucket())
    override val s3Key: Optional[S3Key] = zio.aws.core.internal
      .optionalFromNullable(impl.s3Key())
      .map(value => zio.aws.appstream.model.primitives.S3Key(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appstream.model.S3Location
  ): zio.aws.appstream.model.S3Location.ReadOnly = new Wrapper(impl)
}
