package zio.aws.appstream.model
import scala.jdk.CollectionConverters._
sealed trait PackagingType {
  def unwrap: software.amazon.awssdk.services.appstream.model.PackagingType
}
object PackagingType {
  def wrap(
      value: software.amazon.awssdk.services.appstream.model.PackagingType
  ): zio.aws.appstream.model.PackagingType = value match {
    case software.amazon.awssdk.services.appstream.model.PackagingType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.appstream.model.PackagingType.CUSTOM =>
      val r = CUSTOM
      r
    case software.amazon.awssdk.services.appstream.model.PackagingType.APPSTREAM2 =>
      val r = APPSTREAM2
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.appstream.model.PackagingType {
    override def unwrap
        : software.amazon.awssdk.services.appstream.model.PackagingType =
      software.amazon.awssdk.services.appstream.model.PackagingType.UNKNOWN_TO_SDK_VERSION
  }
  case object CUSTOM extends zio.aws.appstream.model.PackagingType {
    override def unwrap
        : software.amazon.awssdk.services.appstream.model.PackagingType =
      software.amazon.awssdk.services.appstream.model.PackagingType.CUSTOM
  }
  case object APPSTREAM2 extends zio.aws.appstream.model.PackagingType {
    override def unwrap
        : software.amazon.awssdk.services.appstream.model.PackagingType =
      software.amazon.awssdk.services.appstream.model.PackagingType.APPSTREAM2
  }
}
