package zio.aws.appstream.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.appstream.model.primitives.{
  BooleanObject,
  Timestamp,
  Arn,
  Integer,
  UsbDeviceFilterString
}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class Fleet(
    arn: Arn,
    name: String,
    displayName: Optional[String] = Optional.Absent,
    description: Optional[String] = Optional.Absent,
    imageName: Optional[String] = Optional.Absent,
    imageArn: Optional[Arn] = Optional.Absent,
    instanceType: String,
    fleetType: Optional[zio.aws.appstream.model.FleetType] = Optional.Absent,
    computeCapacityStatus: zio.aws.appstream.model.ComputeCapacityStatus,
    maxUserDurationInSeconds: Optional[Integer] = Optional.Absent,
    disconnectTimeoutInSeconds: Optional[Integer] = Optional.Absent,
    state: zio.aws.appstream.model.FleetState,
    vpcConfig: Optional[zio.aws.appstream.model.VpcConfig] = Optional.Absent,
    createdTime: Optional[Timestamp] = Optional.Absent,
    fleetErrors: Optional[Iterable[zio.aws.appstream.model.FleetError]] =
      Optional.Absent,
    enableDefaultInternetAccess: Optional[BooleanObject] = Optional.Absent,
    domainJoinInfo: Optional[zio.aws.appstream.model.DomainJoinInfo] =
      Optional.Absent,
    idleDisconnectTimeoutInSeconds: Optional[Integer] = Optional.Absent,
    iamRoleArn: Optional[Arn] = Optional.Absent,
    streamView: Optional[zio.aws.appstream.model.StreamView] = Optional.Absent,
    platform: Optional[zio.aws.appstream.model.PlatformType] = Optional.Absent,
    maxConcurrentSessions: Optional[Integer] = Optional.Absent,
    usbDeviceFilterStrings: Optional[Iterable[UsbDeviceFilterString]] =
      Optional.Absent,
    sessionScriptS3Location: Optional[zio.aws.appstream.model.S3Location] =
      Optional.Absent,
    maxSessionsPerInstance: Optional[Integer] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.appstream.model.Fleet = {
    import Fleet.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appstream.model.Fleet
      .builder()
      .arn(Arn.unwrap(arn): java.lang.String)
      .name(name: java.lang.String)
      .optionallyWith(displayName.map(value => value: java.lang.String))(
        _.displayName
      )
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(imageName.map(value => value: java.lang.String))(
        _.imageName
      )
      .optionallyWith(
        imageArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.imageArn)
      .instanceType(instanceType: java.lang.String)
      .optionallyWith(fleetType.map(value => value.unwrap))(_.fleetType)
      .computeCapacityStatus(computeCapacityStatus.buildAwsValue())
      .optionallyWith(
        maxUserDurationInSeconds.map(value => value: java.lang.Integer)
      )(_.maxUserDurationInSeconds)
      .optionallyWith(
        disconnectTimeoutInSeconds.map(value => value: java.lang.Integer)
      )(_.disconnectTimeoutInSeconds)
      .state(state.unwrap)
      .optionallyWith(vpcConfig.map(value => value.buildAwsValue()))(
        _.vpcConfig
      )
      .optionallyWith(
        createdTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.createdTime)
      .optionallyWith(
        fleetErrors.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.fleetErrors)
      .optionallyWith(
        enableDefaultInternetAccess.map(value => value: java.lang.Boolean)
      )(_.enableDefaultInternetAccess)
      .optionallyWith(domainJoinInfo.map(value => value.buildAwsValue()))(
        _.domainJoinInfo
      )
      .optionallyWith(
        idleDisconnectTimeoutInSeconds.map(value => value: java.lang.Integer)
      )(_.idleDisconnectTimeoutInSeconds)
      .optionallyWith(
        iamRoleArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.iamRoleArn)
      .optionallyWith(streamView.map(value => value.unwrap))(_.streamView)
      .optionallyWith(platform.map(value => value.unwrap))(_.platform)
      .optionallyWith(
        maxConcurrentSessions.map(value => value: java.lang.Integer)
      )(_.maxConcurrentSessions)
      .optionallyWith(
        usbDeviceFilterStrings.map(value =>
          value.map { item =>
            UsbDeviceFilterString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.usbDeviceFilterStrings)
      .optionallyWith(
        sessionScriptS3Location.map(value => value.buildAwsValue())
      )(_.sessionScriptS3Location)
      .optionallyWith(
        maxSessionsPerInstance.map(value => value: java.lang.Integer)
      )(_.maxSessionsPerInstance)
      .build()
  }
  def asReadOnly: zio.aws.appstream.model.Fleet.ReadOnly =
    zio.aws.appstream.model.Fleet.wrap(buildAwsValue())
}
object Fleet {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.appstream.model.Fleet] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appstream.model.Fleet =
      zio.aws.appstream.model.Fleet(
        arn,
        name,
        displayName.map(value => value),
        description.map(value => value),
        imageName.map(value => value),
        imageArn.map(value => value),
        instanceType,
        fleetType.map(value => value),
        computeCapacityStatus.asEditable,
        maxUserDurationInSeconds.map(value => value),
        disconnectTimeoutInSeconds.map(value => value),
        state,
        vpcConfig.map(value => value.asEditable),
        createdTime.map(value => value),
        fleetErrors.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        enableDefaultInternetAccess.map(value => value),
        domainJoinInfo.map(value => value.asEditable),
        idleDisconnectTimeoutInSeconds.map(value => value),
        iamRoleArn.map(value => value),
        streamView.map(value => value),
        platform.map(value => value),
        maxConcurrentSessions.map(value => value),
        usbDeviceFilterStrings.map(value => value),
        sessionScriptS3Location.map(value => value.asEditable),
        maxSessionsPerInstance.map(value => value)
      )
    def arn: Arn
    def name: String
    def displayName: Optional[String]
    def description: Optional[String]
    def imageName: Optional[String]
    def imageArn: Optional[Arn]
    def instanceType: String
    def fleetType: Optional[zio.aws.appstream.model.FleetType]
    def computeCapacityStatus
        : zio.aws.appstream.model.ComputeCapacityStatus.ReadOnly
    def maxUserDurationInSeconds: Optional[Integer]
    def disconnectTimeoutInSeconds: Optional[Integer]
    def state: zio.aws.appstream.model.FleetState
    def vpcConfig: Optional[zio.aws.appstream.model.VpcConfig.ReadOnly]
    def createdTime: Optional[Timestamp]
    def fleetErrors: Optional[List[zio.aws.appstream.model.FleetError.ReadOnly]]
    def enableDefaultInternetAccess: Optional[BooleanObject]
    def domainJoinInfo
        : Optional[zio.aws.appstream.model.DomainJoinInfo.ReadOnly]
    def idleDisconnectTimeoutInSeconds: Optional[Integer]
    def iamRoleArn: Optional[Arn]
    def streamView: Optional[zio.aws.appstream.model.StreamView]
    def platform: Optional[zio.aws.appstream.model.PlatformType]
    def maxConcurrentSessions: Optional[Integer]
    def usbDeviceFilterStrings: Optional[List[UsbDeviceFilterString]]
    def sessionScriptS3Location
        : Optional[zio.aws.appstream.model.S3Location.ReadOnly]
    def maxSessionsPerInstance: Optional[Integer]
    def getArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(arn)
    def getName: ZIO[Any, Nothing, String] = ZIO.succeed(name)
    def getDisplayName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("displayName", displayName)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getImageName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("imageName", imageName)
    def getImageArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("imageArn", imageArn)
    def getInstanceType: ZIO[Any, Nothing, String] = ZIO.succeed(instanceType)
    def getFleetType: ZIO[Any, AwsError, zio.aws.appstream.model.FleetType] =
      AwsError.unwrapOptionField("fleetType", fleetType)
    def getComputeCapacityStatus: ZIO[
      Any,
      Nothing,
      zio.aws.appstream.model.ComputeCapacityStatus.ReadOnly
    ] = ZIO.succeed(computeCapacityStatus)
    def getMaxUserDurationInSeconds: ZIO[Any, AwsError, Integer] = AwsError
      .unwrapOptionField("maxUserDurationInSeconds", maxUserDurationInSeconds)
    def getDisconnectTimeoutInSeconds: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField(
        "disconnectTimeoutInSeconds",
        disconnectTimeoutInSeconds
      )
    def getState: ZIO[Any, Nothing, zio.aws.appstream.model.FleetState] =
      ZIO.succeed(state)
    def getVpcConfig
        : ZIO[Any, AwsError, zio.aws.appstream.model.VpcConfig.ReadOnly] =
      AwsError.unwrapOptionField("vpcConfig", vpcConfig)
    def getCreatedTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdTime", createdTime)
    def getFleetErrors: ZIO[Any, AwsError, List[
      zio.aws.appstream.model.FleetError.ReadOnly
    ]] = AwsError.unwrapOptionField("fleetErrors", fleetErrors)
    def getEnableDefaultInternetAccess: ZIO[Any, AwsError, BooleanObject] =
      AwsError.unwrapOptionField(
        "enableDefaultInternetAccess",
        enableDefaultInternetAccess
      )
    def getDomainJoinInfo
        : ZIO[Any, AwsError, zio.aws.appstream.model.DomainJoinInfo.ReadOnly] =
      AwsError.unwrapOptionField("domainJoinInfo", domainJoinInfo)
    def getIdleDisconnectTimeoutInSeconds: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField(
        "idleDisconnectTimeoutInSeconds",
        idleDisconnectTimeoutInSeconds
      )
    def getIamRoleArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("iamRoleArn", iamRoleArn)
    def getStreamView: ZIO[Any, AwsError, zio.aws.appstream.model.StreamView] =
      AwsError.unwrapOptionField("streamView", streamView)
    def getPlatform: ZIO[Any, AwsError, zio.aws.appstream.model.PlatformType] =
      AwsError.unwrapOptionField("platform", platform)
    def getMaxConcurrentSessions: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("maxConcurrentSessions", maxConcurrentSessions)
    def getUsbDeviceFilterStrings
        : ZIO[Any, AwsError, List[UsbDeviceFilterString]] = AwsError
      .unwrapOptionField("usbDeviceFilterStrings", usbDeviceFilterStrings)
    def getSessionScriptS3Location
        : ZIO[Any, AwsError, zio.aws.appstream.model.S3Location.ReadOnly] =
      AwsError.unwrapOptionField(
        "sessionScriptS3Location",
        sessionScriptS3Location
      )
    def getMaxSessionsPerInstance: ZIO[Any, AwsError, Integer] = AwsError
      .unwrapOptionField("maxSessionsPerInstance", maxSessionsPerInstance)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appstream.model.Fleet
  ) extends zio.aws.appstream.model.Fleet.ReadOnly {
    override val arn: Arn = zio.aws.appstream.model.primitives.Arn(impl.arn())
    override val name: String = impl.name(): String
    override val displayName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.displayName())
      .map(value => value: String)
    override val description: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => value: String)
    override val imageName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.imageName())
      .map(value => value: String)
    override val imageArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.imageArn())
      .map(value => zio.aws.appstream.model.primitives.Arn(value))
    override val instanceType: String = impl.instanceType(): String
    override val fleetType: Optional[zio.aws.appstream.model.FleetType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.fleetType())
        .map(value => zio.aws.appstream.model.FleetType.wrap(value))
    override val computeCapacityStatus
        : zio.aws.appstream.model.ComputeCapacityStatus.ReadOnly =
      zio.aws.appstream.model.ComputeCapacityStatus
        .wrap(impl.computeCapacityStatus())
    override val maxUserDurationInSeconds: Optional[Integer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxUserDurationInSeconds())
        .map(value => value: Integer)
    override val disconnectTimeoutInSeconds: Optional[Integer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.disconnectTimeoutInSeconds())
        .map(value => value: Integer)
    override val state: zio.aws.appstream.model.FleetState =
      zio.aws.appstream.model.FleetState.wrap(impl.state())
    override val vpcConfig
        : Optional[zio.aws.appstream.model.VpcConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vpcConfig())
        .map(value => zio.aws.appstream.model.VpcConfig.wrap(value))
    override val createdTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.createdTime())
      .map(value => zio.aws.appstream.model.primitives.Timestamp(value))
    override val fleetErrors
        : Optional[List[zio.aws.appstream.model.FleetError.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.fleetErrors())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.appstream.model.FleetError.wrap(item)
          }.toList
        )
    override val enableDefaultInternetAccess: Optional[BooleanObject] =
      zio.aws.core.internal
        .optionalFromNullable(impl.enableDefaultInternetAccess())
        .map(value => value: BooleanObject)
    override val domainJoinInfo
        : Optional[zio.aws.appstream.model.DomainJoinInfo.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.domainJoinInfo())
        .map(value => zio.aws.appstream.model.DomainJoinInfo.wrap(value))
    override val idleDisconnectTimeoutInSeconds: Optional[Integer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.idleDisconnectTimeoutInSeconds())
        .map(value => value: Integer)
    override val iamRoleArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.iamRoleArn())
      .map(value => zio.aws.appstream.model.primitives.Arn(value))
    override val streamView: Optional[zio.aws.appstream.model.StreamView] =
      zio.aws.core.internal
        .optionalFromNullable(impl.streamView())
        .map(value => zio.aws.appstream.model.StreamView.wrap(value))
    override val platform: Optional[zio.aws.appstream.model.PlatformType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.platform())
        .map(value => zio.aws.appstream.model.PlatformType.wrap(value))
    override val maxConcurrentSessions: Optional[Integer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxConcurrentSessions())
        .map(value => value: Integer)
    override val usbDeviceFilterStrings: Optional[List[UsbDeviceFilterString]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.usbDeviceFilterStrings())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.appstream.model.primitives.UsbDeviceFilterString(item)
          }.toList
        )
    override val sessionScriptS3Location
        : Optional[zio.aws.appstream.model.S3Location.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sessionScriptS3Location())
        .map(value => zio.aws.appstream.model.S3Location.wrap(value))
    override val maxSessionsPerInstance: Optional[Integer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxSessionsPerInstance())
        .map(value => value: Integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.appstream.model.Fleet
  ): zio.aws.appstream.model.Fleet.ReadOnly = new Wrapper(impl)
}
