package zio.aws.appstream.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.appstream.model.primitives.{Timestamp, Description, Name}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class Entitlement(
    name: Name,
    stackName: Name,
    description: Optional[Description] = Optional.Absent,
    appVisibility: zio.aws.appstream.model.AppVisibility,
    attributes: Iterable[zio.aws.appstream.model.EntitlementAttribute],
    createdTime: Optional[Timestamp] = Optional.Absent,
    lastModifiedTime: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appstream.model.Entitlement = {
    import Entitlement.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appstream.model.Entitlement
      .builder()
      .name(Name.unwrap(name): java.lang.String)
      .stackName(Name.unwrap(stackName): java.lang.String)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .appVisibility(appVisibility.unwrap)
      .attributes(attributes.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        createdTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.createdTime)
      .optionallyWith(
        lastModifiedTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastModifiedTime)
      .build()
  }
  def asReadOnly: zio.aws.appstream.model.Entitlement.ReadOnly =
    zio.aws.appstream.model.Entitlement.wrap(buildAwsValue())
}
object Entitlement {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appstream.model.Entitlement
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appstream.model.Entitlement =
      zio.aws.appstream.model.Entitlement(
        name,
        stackName,
        description.map(value => value),
        appVisibility,
        attributes.map { item =>
          item.asEditable
        },
        createdTime.map(value => value),
        lastModifiedTime.map(value => value)
      )
    def name: Name
    def stackName: Name
    def description: Optional[Description]
    def appVisibility: zio.aws.appstream.model.AppVisibility
    def attributes: List[zio.aws.appstream.model.EntitlementAttribute.ReadOnly]
    def createdTime: Optional[Timestamp]
    def lastModifiedTime: Optional[Timestamp]
    def getName: ZIO[Any, Nothing, Name] = ZIO.succeed(name)
    def getStackName: ZIO[Any, Nothing, Name] = ZIO.succeed(stackName)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getAppVisibility
        : ZIO[Any, Nothing, zio.aws.appstream.model.AppVisibility] =
      ZIO.succeed(appVisibility)
    def getAttributes: ZIO[Any, Nothing, List[
      zio.aws.appstream.model.EntitlementAttribute.ReadOnly
    ]] = ZIO.succeed(attributes)
    def getCreatedTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdTime", createdTime)
    def getLastModifiedTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastModifiedTime", lastModifiedTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appstream.model.Entitlement
  ) extends zio.aws.appstream.model.Entitlement.ReadOnly {
    override val name: Name =
      zio.aws.appstream.model.primitives.Name(impl.name())
    override val stackName: Name =
      zio.aws.appstream.model.primitives.Name(impl.stackName())
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.appstream.model.primitives.Description(value))
    override val appVisibility: zio.aws.appstream.model.AppVisibility =
      zio.aws.appstream.model.AppVisibility.wrap(impl.appVisibility())
    override val attributes
        : List[zio.aws.appstream.model.EntitlementAttribute.ReadOnly] = impl
      .attributes()
      .asScala
      .map { item =>
        zio.aws.appstream.model.EntitlementAttribute.wrap(item)
      }
      .toList
    override val createdTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.createdTime())
      .map(value => zio.aws.appstream.model.primitives.Timestamp(value))
    override val lastModifiedTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.lastModifiedTime())
      .map(value => zio.aws.appstream.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appstream.model.Entitlement
  ): zio.aws.appstream.model.Entitlement.ReadOnly = new Wrapper(impl)
}
