package zio.aws.appstream.model
import zio.ZIO
import zio.aws.appstream.model.primitives.{
  DisplayName,
  BooleanObject,
  TagValue,
  Arn,
  Integer,
  Description,
  UsbDeviceFilterString,
  Name,
  TagKey
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateFleetRequest(
    name: Name,
    imageName: Optional[Name] = Optional.Absent,
    imageArn: Optional[Arn] = Optional.Absent,
    instanceType: String,
    fleetType: Optional[zio.aws.appstream.model.FleetType] = Optional.Absent,
    computeCapacity: Optional[zio.aws.appstream.model.ComputeCapacity] =
      Optional.Absent,
    vpcConfig: Optional[zio.aws.appstream.model.VpcConfig] = Optional.Absent,
    maxUserDurationInSeconds: Optional[Integer] = Optional.Absent,
    disconnectTimeoutInSeconds: Optional[Integer] = Optional.Absent,
    description: Optional[Description] = Optional.Absent,
    displayName: Optional[DisplayName] = Optional.Absent,
    enableDefaultInternetAccess: Optional[BooleanObject] = Optional.Absent,
    domainJoinInfo: Optional[zio.aws.appstream.model.DomainJoinInfo] =
      Optional.Absent,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent,
    idleDisconnectTimeoutInSeconds: Optional[Integer] = Optional.Absent,
    iamRoleArn: Optional[Arn] = Optional.Absent,
    streamView: Optional[zio.aws.appstream.model.StreamView] = Optional.Absent,
    platform: Optional[zio.aws.appstream.model.PlatformType] = Optional.Absent,
    maxConcurrentSessions: Optional[Integer] = Optional.Absent,
    usbDeviceFilterStrings: Optional[Iterable[UsbDeviceFilterString]] =
      Optional.Absent,
    sessionScriptS3Location: Optional[zio.aws.appstream.model.S3Location] =
      Optional.Absent,
    maxSessionsPerInstance: Optional[Integer] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appstream.model.CreateFleetRequest = {
    import CreateFleetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appstream.model.CreateFleetRequest
      .builder()
      .name(Name.unwrap(name): java.lang.String)
      .optionallyWith(
        imageName.map(value => Name.unwrap(value): java.lang.String)
      )(_.imageName)
      .optionallyWith(
        imageArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.imageArn)
      .instanceType(instanceType: java.lang.String)
      .optionallyWith(fleetType.map(value => value.unwrap))(_.fleetType)
      .optionallyWith(computeCapacity.map(value => value.buildAwsValue()))(
        _.computeCapacity
      )
      .optionallyWith(vpcConfig.map(value => value.buildAwsValue()))(
        _.vpcConfig
      )
      .optionallyWith(
        maxUserDurationInSeconds.map(value => value: java.lang.Integer)
      )(_.maxUserDurationInSeconds)
      .optionallyWith(
        disconnectTimeoutInSeconds.map(value => value: java.lang.Integer)
      )(_.disconnectTimeoutInSeconds)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        displayName.map(value => DisplayName.unwrap(value): java.lang.String)
      )(_.displayName)
      .optionallyWith(
        enableDefaultInternetAccess.map(value => value: java.lang.Boolean)
      )(_.enableDefaultInternetAccess)
      .optionallyWith(domainJoinInfo.map(value => value.buildAwsValue()))(
        _.domainJoinInfo
      )
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(
        idleDisconnectTimeoutInSeconds.map(value => value: java.lang.Integer)
      )(_.idleDisconnectTimeoutInSeconds)
      .optionallyWith(
        iamRoleArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.iamRoleArn)
      .optionallyWith(streamView.map(value => value.unwrap))(_.streamView)
      .optionallyWith(platform.map(value => value.unwrap))(_.platform)
      .optionallyWith(
        maxConcurrentSessions.map(value => value: java.lang.Integer)
      )(_.maxConcurrentSessions)
      .optionallyWith(
        usbDeviceFilterStrings.map(value =>
          value.map { item =>
            UsbDeviceFilterString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.usbDeviceFilterStrings)
      .optionallyWith(
        sessionScriptS3Location.map(value => value.buildAwsValue())
      )(_.sessionScriptS3Location)
      .optionallyWith(
        maxSessionsPerInstance.map(value => value: java.lang.Integer)
      )(_.maxSessionsPerInstance)
      .build()
  }
  def asReadOnly: zio.aws.appstream.model.CreateFleetRequest.ReadOnly =
    zio.aws.appstream.model.CreateFleetRequest.wrap(buildAwsValue())
}
object CreateFleetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appstream.model.CreateFleetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appstream.model.CreateFleetRequest =
      zio.aws.appstream.model.CreateFleetRequest(
        name,
        imageName.map(value => value),
        imageArn.map(value => value),
        instanceType,
        fleetType.map(value => value),
        computeCapacity.map(value => value.asEditable),
        vpcConfig.map(value => value.asEditable),
        maxUserDurationInSeconds.map(value => value),
        disconnectTimeoutInSeconds.map(value => value),
        description.map(value => value),
        displayName.map(value => value),
        enableDefaultInternetAccess.map(value => value),
        domainJoinInfo.map(value => value.asEditable),
        tags.map(value => value),
        idleDisconnectTimeoutInSeconds.map(value => value),
        iamRoleArn.map(value => value),
        streamView.map(value => value),
        platform.map(value => value),
        maxConcurrentSessions.map(value => value),
        usbDeviceFilterStrings.map(value => value),
        sessionScriptS3Location.map(value => value.asEditable),
        maxSessionsPerInstance.map(value => value)
      )
    def name: Name
    def imageName: Optional[Name]
    def imageArn: Optional[Arn]
    def instanceType: String
    def fleetType: Optional[zio.aws.appstream.model.FleetType]
    def computeCapacity
        : Optional[zio.aws.appstream.model.ComputeCapacity.ReadOnly]
    def vpcConfig: Optional[zio.aws.appstream.model.VpcConfig.ReadOnly]
    def maxUserDurationInSeconds: Optional[Integer]
    def disconnectTimeoutInSeconds: Optional[Integer]
    def description: Optional[Description]
    def displayName: Optional[DisplayName]
    def enableDefaultInternetAccess: Optional[BooleanObject]
    def domainJoinInfo
        : Optional[zio.aws.appstream.model.DomainJoinInfo.ReadOnly]
    def tags: Optional[Map[TagKey, TagValue]]
    def idleDisconnectTimeoutInSeconds: Optional[Integer]
    def iamRoleArn: Optional[Arn]
    def streamView: Optional[zio.aws.appstream.model.StreamView]
    def platform: Optional[zio.aws.appstream.model.PlatformType]
    def maxConcurrentSessions: Optional[Integer]
    def usbDeviceFilterStrings: Optional[List[UsbDeviceFilterString]]
    def sessionScriptS3Location
        : Optional[zio.aws.appstream.model.S3Location.ReadOnly]
    def maxSessionsPerInstance: Optional[Integer]
    def getName: ZIO[Any, Nothing, Name] = ZIO.succeed(name)
    def getImageName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("imageName", imageName)
    def getImageArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("imageArn", imageArn)
    def getInstanceType: ZIO[Any, Nothing, String] = ZIO.succeed(instanceType)
    def getFleetType: ZIO[Any, AwsError, zio.aws.appstream.model.FleetType] =
      AwsError.unwrapOptionField("fleetType", fleetType)
    def getComputeCapacity
        : ZIO[Any, AwsError, zio.aws.appstream.model.ComputeCapacity.ReadOnly] =
      AwsError.unwrapOptionField("computeCapacity", computeCapacity)
    def getVpcConfig
        : ZIO[Any, AwsError, zio.aws.appstream.model.VpcConfig.ReadOnly] =
      AwsError.unwrapOptionField("vpcConfig", vpcConfig)
    def getMaxUserDurationInSeconds: ZIO[Any, AwsError, Integer] = AwsError
      .unwrapOptionField("maxUserDurationInSeconds", maxUserDurationInSeconds)
    def getDisconnectTimeoutInSeconds: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField(
        "disconnectTimeoutInSeconds",
        disconnectTimeoutInSeconds
      )
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getDisplayName: ZIO[Any, AwsError, DisplayName] =
      AwsError.unwrapOptionField("displayName", displayName)
    def getEnableDefaultInternetAccess: ZIO[Any, AwsError, BooleanObject] =
      AwsError.unwrapOptionField(
        "enableDefaultInternetAccess",
        enableDefaultInternetAccess
      )
    def getDomainJoinInfo
        : ZIO[Any, AwsError, zio.aws.appstream.model.DomainJoinInfo.ReadOnly] =
      AwsError.unwrapOptionField("domainJoinInfo", domainJoinInfo)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
    def getIdleDisconnectTimeoutInSeconds: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField(
        "idleDisconnectTimeoutInSeconds",
        idleDisconnectTimeoutInSeconds
      )
    def getIamRoleArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("iamRoleArn", iamRoleArn)
    def getStreamView: ZIO[Any, AwsError, zio.aws.appstream.model.StreamView] =
      AwsError.unwrapOptionField("streamView", streamView)
    def getPlatform: ZIO[Any, AwsError, zio.aws.appstream.model.PlatformType] =
      AwsError.unwrapOptionField("platform", platform)
    def getMaxConcurrentSessions: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("maxConcurrentSessions", maxConcurrentSessions)
    def getUsbDeviceFilterStrings
        : ZIO[Any, AwsError, List[UsbDeviceFilterString]] = AwsError
      .unwrapOptionField("usbDeviceFilterStrings", usbDeviceFilterStrings)
    def getSessionScriptS3Location
        : ZIO[Any, AwsError, zio.aws.appstream.model.S3Location.ReadOnly] =
      AwsError.unwrapOptionField(
        "sessionScriptS3Location",
        sessionScriptS3Location
      )
    def getMaxSessionsPerInstance: ZIO[Any, AwsError, Integer] = AwsError
      .unwrapOptionField("maxSessionsPerInstance", maxSessionsPerInstance)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appstream.model.CreateFleetRequest
  ) extends zio.aws.appstream.model.CreateFleetRequest.ReadOnly {
    override val name: Name =
      zio.aws.appstream.model.primitives.Name(impl.name())
    override val imageName: Optional[Name] = zio.aws.core.internal
      .optionalFromNullable(impl.imageName())
      .map(value => zio.aws.appstream.model.primitives.Name(value))
    override val imageArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.imageArn())
      .map(value => zio.aws.appstream.model.primitives.Arn(value))
    override val instanceType: String = impl.instanceType(): String
    override val fleetType: Optional[zio.aws.appstream.model.FleetType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.fleetType())
        .map(value => zio.aws.appstream.model.FleetType.wrap(value))
    override val computeCapacity
        : Optional[zio.aws.appstream.model.ComputeCapacity.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.computeCapacity())
        .map(value => zio.aws.appstream.model.ComputeCapacity.wrap(value))
    override val vpcConfig
        : Optional[zio.aws.appstream.model.VpcConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vpcConfig())
        .map(value => zio.aws.appstream.model.VpcConfig.wrap(value))
    override val maxUserDurationInSeconds: Optional[Integer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxUserDurationInSeconds())
        .map(value => value: Integer)
    override val disconnectTimeoutInSeconds: Optional[Integer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.disconnectTimeoutInSeconds())
        .map(value => value: Integer)
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.appstream.model.primitives.Description(value))
    override val displayName: Optional[DisplayName] = zio.aws.core.internal
      .optionalFromNullable(impl.displayName())
      .map(value => zio.aws.appstream.model.primitives.DisplayName(value))
    override val enableDefaultInternetAccess: Optional[BooleanObject] =
      zio.aws.core.internal
        .optionalFromNullable(impl.enableDefaultInternetAccess())
        .map(value => value: BooleanObject)
    override val domainJoinInfo
        : Optional[zio.aws.appstream.model.DomainJoinInfo.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.domainJoinInfo())
        .map(value => zio.aws.appstream.model.DomainJoinInfo.wrap(value))
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.appstream.model.primitives
              .TagKey(key) -> zio.aws.appstream.model.primitives.TagValue(value)
          })
          .toMap
      )
    override val idleDisconnectTimeoutInSeconds: Optional[Integer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.idleDisconnectTimeoutInSeconds())
        .map(value => value: Integer)
    override val iamRoleArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.iamRoleArn())
      .map(value => zio.aws.appstream.model.primitives.Arn(value))
    override val streamView: Optional[zio.aws.appstream.model.StreamView] =
      zio.aws.core.internal
        .optionalFromNullable(impl.streamView())
        .map(value => zio.aws.appstream.model.StreamView.wrap(value))
    override val platform: Optional[zio.aws.appstream.model.PlatformType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.platform())
        .map(value => zio.aws.appstream.model.PlatformType.wrap(value))
    override val maxConcurrentSessions: Optional[Integer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxConcurrentSessions())
        .map(value => value: Integer)
    override val usbDeviceFilterStrings: Optional[List[UsbDeviceFilterString]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.usbDeviceFilterStrings())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.appstream.model.primitives.UsbDeviceFilterString(item)
          }.toList
        )
    override val sessionScriptS3Location
        : Optional[zio.aws.appstream.model.S3Location.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sessionScriptS3Location())
        .map(value => zio.aws.appstream.model.S3Location.wrap(value))
    override val maxSessionsPerInstance: Optional[Integer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxSessionsPerInstance())
        .map(value => value: Integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.appstream.model.CreateFleetRequest
  ): zio.aws.appstream.model.CreateFleetRequest.ReadOnly = new Wrapper(impl)
}
