package zio.aws.appstream.model
import zio.ZIO
import zio.aws.appstream.model.primitives.Integer
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ComputeCapacityStatus(
    desired: Integer,
    running: Optional[Integer] = Optional.Absent,
    inUse: Optional[Integer] = Optional.Absent,
    available: Optional[Integer] = Optional.Absent,
    desiredUserSessions: Optional[Integer] = Optional.Absent,
    availableUserSessions: Optional[Integer] = Optional.Absent,
    activeUserSessions: Optional[Integer] = Optional.Absent,
    actualUserSessions: Optional[Integer] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appstream.model.ComputeCapacityStatus = {
    import ComputeCapacityStatus.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appstream.model.ComputeCapacityStatus
      .builder()
      .desired(desired: java.lang.Integer)
      .optionallyWith(running.map(value => value: java.lang.Integer))(_.running)
      .optionallyWith(inUse.map(value => value: java.lang.Integer))(_.inUse)
      .optionallyWith(available.map(value => value: java.lang.Integer))(
        _.available
      )
      .optionallyWith(
        desiredUserSessions.map(value => value: java.lang.Integer)
      )(_.desiredUserSessions)
      .optionallyWith(
        availableUserSessions.map(value => value: java.lang.Integer)
      )(_.availableUserSessions)
      .optionallyWith(
        activeUserSessions.map(value => value: java.lang.Integer)
      )(_.activeUserSessions)
      .optionallyWith(
        actualUserSessions.map(value => value: java.lang.Integer)
      )(_.actualUserSessions)
      .build()
  }
  def asReadOnly: zio.aws.appstream.model.ComputeCapacityStatus.ReadOnly =
    zio.aws.appstream.model.ComputeCapacityStatus.wrap(buildAwsValue())
}
object ComputeCapacityStatus {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appstream.model.ComputeCapacityStatus
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appstream.model.ComputeCapacityStatus =
      zio.aws.appstream.model.ComputeCapacityStatus(
        desired,
        running.map(value => value),
        inUse.map(value => value),
        available.map(value => value),
        desiredUserSessions.map(value => value),
        availableUserSessions.map(value => value),
        activeUserSessions.map(value => value),
        actualUserSessions.map(value => value)
      )
    def desired: Integer
    def running: Optional[Integer]
    def inUse: Optional[Integer]
    def available: Optional[Integer]
    def desiredUserSessions: Optional[Integer]
    def availableUserSessions: Optional[Integer]
    def activeUserSessions: Optional[Integer]
    def actualUserSessions: Optional[Integer]
    def getDesired: ZIO[Any, Nothing, Integer] = ZIO.succeed(desired)
    def getRunning: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("running", running)
    def getInUse: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("inUse", inUse)
    def getAvailable: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("available", available)
    def getDesiredUserSessions: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("desiredUserSessions", desiredUserSessions)
    def getAvailableUserSessions: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("availableUserSessions", availableUserSessions)
    def getActiveUserSessions: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("activeUserSessions", activeUserSessions)
    def getActualUserSessions: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("actualUserSessions", actualUserSessions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appstream.model.ComputeCapacityStatus
  ) extends zio.aws.appstream.model.ComputeCapacityStatus.ReadOnly {
    override val desired: Integer = impl.desired(): Integer
    override val running: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.running())
      .map(value => value: Integer)
    override val inUse: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.inUse())
      .map(value => value: Integer)
    override val available: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.available())
      .map(value => value: Integer)
    override val desiredUserSessions: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.desiredUserSessions())
      .map(value => value: Integer)
    override val availableUserSessions: Optional[Integer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.availableUserSessions())
        .map(value => value: Integer)
    override val activeUserSessions: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.activeUserSessions())
      .map(value => value: Integer)
    override val actualUserSessions: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.actualUserSessions())
      .map(value => value: Integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.appstream.model.ComputeCapacityStatus
  ): zio.aws.appstream.model.ComputeCapacityStatus.ReadOnly = new Wrapper(impl)
}
