package zio.aws.appstream.model
import zio.ZIO
import zio.aws.appstream.model.primitives.Integer
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ComputeCapacity(
    desiredInstances: Optional[Integer] = Optional.Absent,
    desiredSessions: Optional[Integer] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appstream.model.ComputeCapacity = {
    import ComputeCapacity.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appstream.model.ComputeCapacity
      .builder()
      .optionallyWith(desiredInstances.map(value => value: java.lang.Integer))(
        _.desiredInstances
      )
      .optionallyWith(desiredSessions.map(value => value: java.lang.Integer))(
        _.desiredSessions
      )
      .build()
  }
  def asReadOnly: zio.aws.appstream.model.ComputeCapacity.ReadOnly =
    zio.aws.appstream.model.ComputeCapacity.wrap(buildAwsValue())
}
object ComputeCapacity {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appstream.model.ComputeCapacity
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appstream.model.ComputeCapacity =
      zio.aws.appstream.model.ComputeCapacity(
        desiredInstances.map(value => value),
        desiredSessions.map(value => value)
      )
    def desiredInstances: Optional[Integer]
    def desiredSessions: Optional[Integer]
    def getDesiredInstances: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("desiredInstances", desiredInstances)
    def getDesiredSessions: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("desiredSessions", desiredSessions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appstream.model.ComputeCapacity
  ) extends zio.aws.appstream.model.ComputeCapacity.ReadOnly {
    override val desiredInstances: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.desiredInstances())
      .map(value => value: Integer)
    override val desiredSessions: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.desiredSessions())
      .map(value => value: Integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.appstream.model.ComputeCapacity
  ): zio.aws.appstream.model.ComputeCapacity.ReadOnly = new Wrapper(impl)
}
