package zio.aws.appstream.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AppBlockBuilderStateChangeReason(
    code: Optional[
      zio.aws.appstream.model.AppBlockBuilderStateChangeReasonCode
    ] = Optional.Absent,
    message: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appstream.model.AppBlockBuilderStateChangeReason = {
    import AppBlockBuilderStateChangeReason.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appstream.model.AppBlockBuilderStateChangeReason
      .builder()
      .optionallyWith(code.map(value => value.unwrap))(_.code)
      .optionallyWith(message.map(value => value: java.lang.String))(_.message)
      .build()
  }
  def asReadOnly
      : zio.aws.appstream.model.AppBlockBuilderStateChangeReason.ReadOnly =
    zio.aws.appstream.model.AppBlockBuilderStateChangeReason
      .wrap(buildAwsValue())
}
object AppBlockBuilderStateChangeReason {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appstream.model.AppBlockBuilderStateChangeReason
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appstream.model.AppBlockBuilderStateChangeReason =
      zio.aws.appstream.model.AppBlockBuilderStateChangeReason(
        code.map(value => value),
        message.map(value => value)
      )
    def code
        : Optional[zio.aws.appstream.model.AppBlockBuilderStateChangeReasonCode]
    def message: Optional[String]
    def getCode: ZIO[
      Any,
      AwsError,
      zio.aws.appstream.model.AppBlockBuilderStateChangeReasonCode
    ] = AwsError.unwrapOptionField("code", code)
    def getMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("message", message)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appstream.model.AppBlockBuilderStateChangeReason
  ) extends zio.aws.appstream.model.AppBlockBuilderStateChangeReason.ReadOnly {
    override val code: Optional[
      zio.aws.appstream.model.AppBlockBuilderStateChangeReasonCode
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.code())
      .map(value =>
        zio.aws.appstream.model.AppBlockBuilderStateChangeReasonCode.wrap(value)
      )
    override val message: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.message())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.appstream.model.AppBlockBuilderStateChangeReason
  ): zio.aws.appstream.model.AppBlockBuilderStateChangeReason.ReadOnly =
    new Wrapper(impl)
}
