package zio.aws.appstream.model
import scala.jdk.CollectionConverters._
sealed trait AppBlockBuilderState {
  def unwrap
      : software.amazon.awssdk.services.appstream.model.AppBlockBuilderState
}
object AppBlockBuilderState {
  def wrap(
      value: software.amazon.awssdk.services.appstream.model.AppBlockBuilderState
  ): zio.aws.appstream.model.AppBlockBuilderState = value match {
    case software.amazon.awssdk.services.appstream.model.AppBlockBuilderState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.appstream.model.AppBlockBuilderState.STARTING =>
      val r = STARTING
      r
    case software.amazon.awssdk.services.appstream.model.AppBlockBuilderState.RUNNING =>
      val r = RUNNING
      r
    case software.amazon.awssdk.services.appstream.model.AppBlockBuilderState.STOPPING =>
      val r = STOPPING
      r
    case software.amazon.awssdk.services.appstream.model.AppBlockBuilderState.STOPPED =>
      val r = STOPPED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.appstream.model.AppBlockBuilderState {
    override def unwrap
        : software.amazon.awssdk.services.appstream.model.AppBlockBuilderState =
      software.amazon.awssdk.services.appstream.model.AppBlockBuilderState.UNKNOWN_TO_SDK_VERSION
  }
  case object STARTING extends zio.aws.appstream.model.AppBlockBuilderState {
    override def unwrap
        : software.amazon.awssdk.services.appstream.model.AppBlockBuilderState =
      software.amazon.awssdk.services.appstream.model.AppBlockBuilderState.STARTING
  }
  case object RUNNING extends zio.aws.appstream.model.AppBlockBuilderState {
    override def unwrap
        : software.amazon.awssdk.services.appstream.model.AppBlockBuilderState =
      software.amazon.awssdk.services.appstream.model.AppBlockBuilderState.RUNNING
  }
  case object STOPPING extends zio.aws.appstream.model.AppBlockBuilderState {
    override def unwrap
        : software.amazon.awssdk.services.appstream.model.AppBlockBuilderState =
      software.amazon.awssdk.services.appstream.model.AppBlockBuilderState.STOPPING
  }
  case object STOPPED extends zio.aws.appstream.model.AppBlockBuilderState {
    override def unwrap
        : software.amazon.awssdk.services.appstream.model.AppBlockBuilderState =
      software.amazon.awssdk.services.appstream.model.AppBlockBuilderState.STOPPED
  }
}
