package zio.aws.appstream.model
import scala.jdk.CollectionConverters._
sealed trait AppBlockBuilderAttribute {
  def unwrap
      : software.amazon.awssdk.services.appstream.model.AppBlockBuilderAttribute
}
object AppBlockBuilderAttribute {
  def wrap(
      value: software.amazon.awssdk.services.appstream.model.AppBlockBuilderAttribute
  ): zio.aws.appstream.model.AppBlockBuilderAttribute = value match {
    case software.amazon.awssdk.services.appstream.model.AppBlockBuilderAttribute.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.appstream.model.AppBlockBuilderAttribute.IAM_ROLE_ARN =>
      val r = IAM_ROLE_ARN
      r
    case software.amazon.awssdk.services.appstream.model.AppBlockBuilderAttribute.ACCESS_ENDPOINTS =>
      val r = ACCESS_ENDPOINTS
      r
    case software.amazon.awssdk.services.appstream.model.AppBlockBuilderAttribute.VPC_CONFIGURATION_SECURITY_GROUP_IDS =>
      val r = VPC_CONFIGURATION_SECURITY_GROUP_IDS
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.appstream.model.AppBlockBuilderAttribute {
    override def unwrap
        : software.amazon.awssdk.services.appstream.model.AppBlockBuilderAttribute =
      software.amazon.awssdk.services.appstream.model.AppBlockBuilderAttribute.UNKNOWN_TO_SDK_VERSION
  }
  case object IAM_ROLE_ARN
      extends zio.aws.appstream.model.AppBlockBuilderAttribute {
    override def unwrap
        : software.amazon.awssdk.services.appstream.model.AppBlockBuilderAttribute =
      software.amazon.awssdk.services.appstream.model.AppBlockBuilderAttribute.IAM_ROLE_ARN
  }
  case object ACCESS_ENDPOINTS
      extends zio.aws.appstream.model.AppBlockBuilderAttribute {
    override def unwrap
        : software.amazon.awssdk.services.appstream.model.AppBlockBuilderAttribute =
      software.amazon.awssdk.services.appstream.model.AppBlockBuilderAttribute.ACCESS_ENDPOINTS
  }
  case object VPC_CONFIGURATION_SECURITY_GROUP_IDS
      extends zio.aws.appstream.model.AppBlockBuilderAttribute {
    override def unwrap
        : software.amazon.awssdk.services.appstream.model.AppBlockBuilderAttribute =
      software.amazon.awssdk.services.appstream.model.AppBlockBuilderAttribute.VPC_CONFIGURATION_SECURITY_GROUP_IDS
  }
}
