package zio.aws.appstream.model
import zio.ZIO
import zio.aws.appstream.model.primitives.{
  DisplayName,
  Description,
  RedirectURL,
  EmbedHostDomain,
  FeedbackURL
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateStackRequest(
    displayName: Optional[DisplayName] = Optional.Absent,
    description: Optional[Description] = Optional.Absent,
    name: String,
    storageConnectors: Optional[
      Iterable[zio.aws.appstream.model.StorageConnector]
    ] = Optional.Absent,
    deleteStorageConnectors: Optional[Boolean] = Optional.Absent,
    redirectURL: Optional[RedirectURL] = Optional.Absent,
    feedbackURL: Optional[FeedbackURL] = Optional.Absent,
    attributesToDelete: Optional[
      Iterable[zio.aws.appstream.model.StackAttribute]
    ] = Optional.Absent,
    userSettings: Optional[Iterable[zio.aws.appstream.model.UserSetting]] =
      Optional.Absent,
    applicationSettings: Optional[zio.aws.appstream.model.ApplicationSettings] =
      Optional.Absent,
    accessEndpoints: Optional[
      Iterable[zio.aws.appstream.model.AccessEndpoint]
    ] = Optional.Absent,
    embedHostDomains: Optional[Iterable[EmbedHostDomain]] = Optional.Absent,
    streamingExperienceSettings: Optional[
      zio.aws.appstream.model.StreamingExperienceSettings
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appstream.model.UpdateStackRequest = {
    import UpdateStackRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appstream.model.UpdateStackRequest
      .builder()
      .optionallyWith(
        displayName.map(value => DisplayName.unwrap(value): java.lang.String)
      )(_.displayName)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .name(name: java.lang.String)
      .optionallyWith(
        storageConnectors.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.storageConnectors)
      .optionallyWith(
        deleteStorageConnectors.map(value => value: java.lang.Boolean)
      )(_.deleteStorageConnectors)
      .optionallyWith(
        redirectURL.map(value => RedirectURL.unwrap(value): java.lang.String)
      )(_.redirectURL)
      .optionallyWith(
        feedbackURL.map(value => FeedbackURL.unwrap(value): java.lang.String)
      )(_.feedbackURL)
      .optionallyWith(
        attributesToDelete.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.attributesToDeleteWithStrings)
      .optionallyWith(
        userSettings.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.userSettings)
      .optionallyWith(applicationSettings.map(value => value.buildAwsValue()))(
        _.applicationSettings
      )
      .optionallyWith(
        accessEndpoints.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.accessEndpoints)
      .optionallyWith(
        embedHostDomains.map(value =>
          value.map { item =>
            EmbedHostDomain.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.embedHostDomains)
      .optionallyWith(
        streamingExperienceSettings.map(value => value.buildAwsValue())
      )(_.streamingExperienceSettings)
      .build()
  }
  def asReadOnly: zio.aws.appstream.model.UpdateStackRequest.ReadOnly =
    zio.aws.appstream.model.UpdateStackRequest.wrap(buildAwsValue())
}
object UpdateStackRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appstream.model.UpdateStackRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appstream.model.UpdateStackRequest =
      zio.aws.appstream.model.UpdateStackRequest(
        displayName.map(value => value),
        description.map(value => value),
        name,
        storageConnectors.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        deleteStorageConnectors.map(value => value),
        redirectURL.map(value => value),
        feedbackURL.map(value => value),
        attributesToDelete.map(value => value),
        userSettings.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        applicationSettings.map(value => value.asEditable),
        accessEndpoints.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        embedHostDomains.map(value => value),
        streamingExperienceSettings.map(value => value.asEditable)
      )
    def displayName: Optional[DisplayName]
    def description: Optional[Description]
    def name: String
    def storageConnectors
        : Optional[List[zio.aws.appstream.model.StorageConnector.ReadOnly]]
    def deleteStorageConnectors: Optional[Boolean]
    def redirectURL: Optional[RedirectURL]
    def feedbackURL: Optional[FeedbackURL]
    def attributesToDelete
        : Optional[List[zio.aws.appstream.model.StackAttribute]]
    def userSettings
        : Optional[List[zio.aws.appstream.model.UserSetting.ReadOnly]]
    def applicationSettings
        : Optional[zio.aws.appstream.model.ApplicationSettings.ReadOnly]
    def accessEndpoints
        : Optional[List[zio.aws.appstream.model.AccessEndpoint.ReadOnly]]
    def embedHostDomains: Optional[List[EmbedHostDomain]]
    def streamingExperienceSettings
        : Optional[zio.aws.appstream.model.StreamingExperienceSettings.ReadOnly]
    def getDisplayName: ZIO[Any, AwsError, DisplayName] =
      AwsError.unwrapOptionField("displayName", displayName)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getName: ZIO[Any, Nothing, String] = ZIO.succeed(name)
    def getStorageConnectors: ZIO[Any, AwsError, List[
      zio.aws.appstream.model.StorageConnector.ReadOnly
    ]] = AwsError.unwrapOptionField("storageConnectors", storageConnectors)
    def getDeleteStorageConnectors: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("deleteStorageConnectors", deleteStorageConnectors)
    def getRedirectURL: ZIO[Any, AwsError, RedirectURL] =
      AwsError.unwrapOptionField("redirectURL", redirectURL)
    def getFeedbackURL: ZIO[Any, AwsError, FeedbackURL] =
      AwsError.unwrapOptionField("feedbackURL", feedbackURL)
    def getAttributesToDelete
        : ZIO[Any, AwsError, List[zio.aws.appstream.model.StackAttribute]] =
      AwsError.unwrapOptionField("attributesToDelete", attributesToDelete)
    def getUserSettings: ZIO[Any, AwsError, List[
      zio.aws.appstream.model.UserSetting.ReadOnly
    ]] = AwsError.unwrapOptionField("userSettings", userSettings)
    def getApplicationSettings: ZIO[
      Any,
      AwsError,
      zio.aws.appstream.model.ApplicationSettings.ReadOnly
    ] = AwsError.unwrapOptionField("applicationSettings", applicationSettings)
    def getAccessEndpoints: ZIO[Any, AwsError, List[
      zio.aws.appstream.model.AccessEndpoint.ReadOnly
    ]] = AwsError.unwrapOptionField("accessEndpoints", accessEndpoints)
    def getEmbedHostDomains: ZIO[Any, AwsError, List[EmbedHostDomain]] =
      AwsError.unwrapOptionField("embedHostDomains", embedHostDomains)
    def getStreamingExperienceSettings: ZIO[
      Any,
      AwsError,
      zio.aws.appstream.model.StreamingExperienceSettings.ReadOnly
    ] = AwsError.unwrapOptionField(
      "streamingExperienceSettings",
      streamingExperienceSettings
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appstream.model.UpdateStackRequest
  ) extends zio.aws.appstream.model.UpdateStackRequest.ReadOnly {
    override val displayName: Optional[DisplayName] = zio.aws.core.internal
      .optionalFromNullable(impl.displayName())
      .map(value => zio.aws.appstream.model.primitives.DisplayName(value))
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.appstream.model.primitives.Description(value))
    override val name: String = impl.name(): String
    override val storageConnectors
        : Optional[List[zio.aws.appstream.model.StorageConnector.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.storageConnectors())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.appstream.model.StorageConnector.wrap(item)
          }.toList
        )
    override val deleteStorageConnectors: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.deleteStorageConnectors())
        .map(value => value: Boolean)
    override val redirectURL: Optional[RedirectURL] = zio.aws.core.internal
      .optionalFromNullable(impl.redirectURL())
      .map(value => zio.aws.appstream.model.primitives.RedirectURL(value))
    override val feedbackURL: Optional[FeedbackURL] = zio.aws.core.internal
      .optionalFromNullable(impl.feedbackURL())
      .map(value => zio.aws.appstream.model.primitives.FeedbackURL(value))
    override val attributesToDelete
        : Optional[List[zio.aws.appstream.model.StackAttribute]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.attributesToDelete())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.appstream.model.StackAttribute.wrap(item)
          }.toList
        )
    override val userSettings
        : Optional[List[zio.aws.appstream.model.UserSetting.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.userSettings())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.appstream.model.UserSetting.wrap(item)
          }.toList
        )
    override val applicationSettings
        : Optional[zio.aws.appstream.model.ApplicationSettings.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.applicationSettings())
        .map(value => zio.aws.appstream.model.ApplicationSettings.wrap(value))
    override val accessEndpoints
        : Optional[List[zio.aws.appstream.model.AccessEndpoint.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.accessEndpoints())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.appstream.model.AccessEndpoint.wrap(item)
          }.toList
        )
    override val embedHostDomains: Optional[List[EmbedHostDomain]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.embedHostDomains())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.appstream.model.primitives.EmbedHostDomain(item)
          }.toList
        )
    override val streamingExperienceSettings: Optional[
      zio.aws.appstream.model.StreamingExperienceSettings.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.streamingExperienceSettings())
      .map(value =>
        zio.aws.appstream.model.StreamingExperienceSettings.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.appstream.model.UpdateStackRequest
  ): zio.aws.appstream.model.UpdateStackRequest.ReadOnly = new Wrapper(impl)
}
