package zio.aws.appstream.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateDirectoryConfigResponse(
    directoryConfig: Optional[zio.aws.appstream.model.DirectoryConfig] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appstream.model.UpdateDirectoryConfigResponse = {
    import UpdateDirectoryConfigResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appstream.model.UpdateDirectoryConfigResponse
      .builder()
      .optionallyWith(directoryConfig.map(value => value.buildAwsValue()))(
        _.directoryConfig
      )
      .build()
  }
  def asReadOnly
      : zio.aws.appstream.model.UpdateDirectoryConfigResponse.ReadOnly =
    zio.aws.appstream.model.UpdateDirectoryConfigResponse.wrap(buildAwsValue())
}
object UpdateDirectoryConfigResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appstream.model.UpdateDirectoryConfigResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appstream.model.UpdateDirectoryConfigResponse =
      zio.aws.appstream.model.UpdateDirectoryConfigResponse(
        directoryConfig.map(value => value.asEditable)
      )
    def directoryConfig
        : Optional[zio.aws.appstream.model.DirectoryConfig.ReadOnly]
    def getDirectoryConfig
        : ZIO[Any, AwsError, zio.aws.appstream.model.DirectoryConfig.ReadOnly] =
      AwsError.unwrapOptionField("directoryConfig", directoryConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appstream.model.UpdateDirectoryConfigResponse
  ) extends zio.aws.appstream.model.UpdateDirectoryConfigResponse.ReadOnly {
    override val directoryConfig
        : Optional[zio.aws.appstream.model.DirectoryConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.directoryConfig())
        .map(value => zio.aws.appstream.model.DirectoryConfig.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appstream.model.UpdateDirectoryConfigResponse
  ): zio.aws.appstream.model.UpdateDirectoryConfigResponse.ReadOnly =
    new Wrapper(impl)
}
