package zio.aws.appstream.model
import scala.jdk.CollectionConverters._
sealed trait StreamView {
  def unwrap: software.amazon.awssdk.services.appstream.model.StreamView
}
object StreamView {
  def wrap(
      value: software.amazon.awssdk.services.appstream.model.StreamView
  ): zio.aws.appstream.model.StreamView = value match {
    case software.amazon.awssdk.services.appstream.model.StreamView.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.appstream.model.StreamView.APP =>
      val r = APP
      r
    case software.amazon.awssdk.services.appstream.model.StreamView.DESKTOP =>
      val r = DESKTOP
      r
  }
  case object unknownToSdkVersion extends zio.aws.appstream.model.StreamView {
    override def unwrap
        : software.amazon.awssdk.services.appstream.model.StreamView =
      software.amazon.awssdk.services.appstream.model.StreamView.UNKNOWN_TO_SDK_VERSION
  }
  case object APP extends zio.aws.appstream.model.StreamView {
    override def unwrap
        : software.amazon.awssdk.services.appstream.model.StreamView =
      software.amazon.awssdk.services.appstream.model.StreamView.APP
  }
  case object DESKTOP extends zio.aws.appstream.model.StreamView {
    override def unwrap
        : software.amazon.awssdk.services.appstream.model.StreamView =
      software.amazon.awssdk.services.appstream.model.StreamView.DESKTOP
  }
}
