package zio.aws.appstream.model
import scala.jdk.CollectionConverters._
sealed trait PlatformType {
  def unwrap: software.amazon.awssdk.services.appstream.model.PlatformType
}
object PlatformType {
  def wrap(
      value: software.amazon.awssdk.services.appstream.model.PlatformType
  ): zio.aws.appstream.model.PlatformType = value match {
    case software.amazon.awssdk.services.appstream.model.PlatformType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.appstream.model.PlatformType.WINDOWS =>
      val r = WINDOWS
      r
    case software.amazon.awssdk.services.appstream.model.PlatformType.WINDOWS_SERVER_2016 =>
      val r = WINDOWS_SERVER_2016
      r
    case software.amazon.awssdk.services.appstream.model.PlatformType.WINDOWS_SERVER_2019 =>
      val r = WINDOWS_SERVER_2019
      r
    case software.amazon.awssdk.services.appstream.model.PlatformType.AMAZON_LINUX2 =>
      val r = AMAZON_LINUX2
      r
  }
  case object unknownToSdkVersion extends zio.aws.appstream.model.PlatformType {
    override def unwrap
        : software.amazon.awssdk.services.appstream.model.PlatformType =
      software.amazon.awssdk.services.appstream.model.PlatformType.UNKNOWN_TO_SDK_VERSION
  }
  case object WINDOWS extends zio.aws.appstream.model.PlatformType {
    override def unwrap
        : software.amazon.awssdk.services.appstream.model.PlatformType =
      software.amazon.awssdk.services.appstream.model.PlatformType.WINDOWS
  }
  case object WINDOWS_SERVER_2016 extends zio.aws.appstream.model.PlatformType {
    override def unwrap
        : software.amazon.awssdk.services.appstream.model.PlatformType =
      software.amazon.awssdk.services.appstream.model.PlatformType.WINDOWS_SERVER_2016
  }
  case object WINDOWS_SERVER_2019 extends zio.aws.appstream.model.PlatformType {
    override def unwrap
        : software.amazon.awssdk.services.appstream.model.PlatformType =
      software.amazon.awssdk.services.appstream.model.PlatformType.WINDOWS_SERVER_2019
  }
  case object AMAZON_LINUX2 extends zio.aws.appstream.model.PlatformType {
    override def unwrap
        : software.amazon.awssdk.services.appstream.model.PlatformType =
      software.amazon.awssdk.services.appstream.model.PlatformType.AMAZON_LINUX2
  }
}
