package zio.aws.appstream.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.appstream.model.primitives.{
  AppstreamAgentVersion,
  BooleanObject,
  Timestamp,
  Arn
}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class ImageBuilder(
    name: String,
    arn: Optional[Arn] = Optional.Absent,
    imageArn: Optional[Arn] = Optional.Absent,
    description: Optional[String] = Optional.Absent,
    displayName: Optional[String] = Optional.Absent,
    vpcConfig: Optional[zio.aws.appstream.model.VpcConfig] = Optional.Absent,
    instanceType: Optional[String] = Optional.Absent,
    platform: Optional[zio.aws.appstream.model.PlatformType] = Optional.Absent,
    iamRoleArn: Optional[Arn] = Optional.Absent,
    state: Optional[zio.aws.appstream.model.ImageBuilderState] =
      Optional.Absent,
    stateChangeReason: Optional[
      zio.aws.appstream.model.ImageBuilderStateChangeReason
    ] = Optional.Absent,
    createdTime: Optional[Timestamp] = Optional.Absent,
    enableDefaultInternetAccess: Optional[BooleanObject] = Optional.Absent,
    domainJoinInfo: Optional[zio.aws.appstream.model.DomainJoinInfo] =
      Optional.Absent,
    networkAccessConfiguration: Optional[
      zio.aws.appstream.model.NetworkAccessConfiguration
    ] = Optional.Absent,
    imageBuilderErrors: Optional[
      Iterable[zio.aws.appstream.model.ResourceError]
    ] = Optional.Absent,
    appstreamAgentVersion: Optional[AppstreamAgentVersion] = Optional.Absent,
    accessEndpoints: Optional[
      Iterable[zio.aws.appstream.model.AccessEndpoint]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appstream.model.ImageBuilder = {
    import ImageBuilder.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appstream.model.ImageBuilder
      .builder()
      .name(name: java.lang.String)
      .optionallyWith(arn.map(value => Arn.unwrap(value): java.lang.String))(
        _.arn
      )
      .optionallyWith(
        imageArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.imageArn)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(displayName.map(value => value: java.lang.String))(
        _.displayName
      )
      .optionallyWith(vpcConfig.map(value => value.buildAwsValue()))(
        _.vpcConfig
      )
      .optionallyWith(instanceType.map(value => value: java.lang.String))(
        _.instanceType
      )
      .optionallyWith(platform.map(value => value.unwrap))(_.platform)
      .optionallyWith(
        iamRoleArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.iamRoleArn)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(stateChangeReason.map(value => value.buildAwsValue()))(
        _.stateChangeReason
      )
      .optionallyWith(
        createdTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.createdTime)
      .optionallyWith(
        enableDefaultInternetAccess.map(value => value: java.lang.Boolean)
      )(_.enableDefaultInternetAccess)
      .optionallyWith(domainJoinInfo.map(value => value.buildAwsValue()))(
        _.domainJoinInfo
      )
      .optionallyWith(
        networkAccessConfiguration.map(value => value.buildAwsValue())
      )(_.networkAccessConfiguration)
      .optionallyWith(
        imageBuilderErrors.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.imageBuilderErrors)
      .optionallyWith(
        appstreamAgentVersion.map(value =>
          AppstreamAgentVersion.unwrap(value): java.lang.String
        )
      )(_.appstreamAgentVersion)
      .optionallyWith(
        accessEndpoints.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.accessEndpoints)
      .build()
  }
  def asReadOnly: zio.aws.appstream.model.ImageBuilder.ReadOnly =
    zio.aws.appstream.model.ImageBuilder.wrap(buildAwsValue())
}
object ImageBuilder {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appstream.model.ImageBuilder
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appstream.model.ImageBuilder =
      zio.aws.appstream.model.ImageBuilder(
        name,
        arn.map(value => value),
        imageArn.map(value => value),
        description.map(value => value),
        displayName.map(value => value),
        vpcConfig.map(value => value.asEditable),
        instanceType.map(value => value),
        platform.map(value => value),
        iamRoleArn.map(value => value),
        state.map(value => value),
        stateChangeReason.map(value => value.asEditable),
        createdTime.map(value => value),
        enableDefaultInternetAccess.map(value => value),
        domainJoinInfo.map(value => value.asEditable),
        networkAccessConfiguration.map(value => value.asEditable),
        imageBuilderErrors.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        appstreamAgentVersion.map(value => value),
        accessEndpoints.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def name: String
    def arn: Optional[Arn]
    def imageArn: Optional[Arn]
    def description: Optional[String]
    def displayName: Optional[String]
    def vpcConfig: Optional[zio.aws.appstream.model.VpcConfig.ReadOnly]
    def instanceType: Optional[String]
    def platform: Optional[zio.aws.appstream.model.PlatformType]
    def iamRoleArn: Optional[Arn]
    def state: Optional[zio.aws.appstream.model.ImageBuilderState]
    def stateChangeReason: Optional[
      zio.aws.appstream.model.ImageBuilderStateChangeReason.ReadOnly
    ]
    def createdTime: Optional[Timestamp]
    def enableDefaultInternetAccess: Optional[BooleanObject]
    def domainJoinInfo
        : Optional[zio.aws.appstream.model.DomainJoinInfo.ReadOnly]
    def networkAccessConfiguration
        : Optional[zio.aws.appstream.model.NetworkAccessConfiguration.ReadOnly]
    def imageBuilderErrors
        : Optional[List[zio.aws.appstream.model.ResourceError.ReadOnly]]
    def appstreamAgentVersion: Optional[AppstreamAgentVersion]
    def accessEndpoints
        : Optional[List[zio.aws.appstream.model.AccessEndpoint.ReadOnly]]
    def getName: ZIO[Any, Nothing, String] = ZIO.succeed(name)
    def getArn: ZIO[Any, AwsError, Arn] = AwsError.unwrapOptionField("arn", arn)
    def getImageArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("imageArn", imageArn)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getDisplayName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("displayName", displayName)
    def getVpcConfig
        : ZIO[Any, AwsError, zio.aws.appstream.model.VpcConfig.ReadOnly] =
      AwsError.unwrapOptionField("vpcConfig", vpcConfig)
    def getInstanceType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("instanceType", instanceType)
    def getPlatform: ZIO[Any, AwsError, zio.aws.appstream.model.PlatformType] =
      AwsError.unwrapOptionField("platform", platform)
    def getIamRoleArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("iamRoleArn", iamRoleArn)
    def getState
        : ZIO[Any, AwsError, zio.aws.appstream.model.ImageBuilderState] =
      AwsError.unwrapOptionField("state", state)
    def getStateChangeReason: ZIO[
      Any,
      AwsError,
      zio.aws.appstream.model.ImageBuilderStateChangeReason.ReadOnly
    ] = AwsError.unwrapOptionField("stateChangeReason", stateChangeReason)
    def getCreatedTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdTime", createdTime)
    def getEnableDefaultInternetAccess: ZIO[Any, AwsError, BooleanObject] =
      AwsError.unwrapOptionField(
        "enableDefaultInternetAccess",
        enableDefaultInternetAccess
      )
    def getDomainJoinInfo
        : ZIO[Any, AwsError, zio.aws.appstream.model.DomainJoinInfo.ReadOnly] =
      AwsError.unwrapOptionField("domainJoinInfo", domainJoinInfo)
    def getNetworkAccessConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.appstream.model.NetworkAccessConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "networkAccessConfiguration",
      networkAccessConfiguration
    )
    def getImageBuilderErrors: ZIO[Any, AwsError, List[
      zio.aws.appstream.model.ResourceError.ReadOnly
    ]] = AwsError.unwrapOptionField("imageBuilderErrors", imageBuilderErrors)
    def getAppstreamAgentVersion: ZIO[Any, AwsError, AppstreamAgentVersion] =
      AwsError.unwrapOptionField("appstreamAgentVersion", appstreamAgentVersion)
    def getAccessEndpoints: ZIO[Any, AwsError, List[
      zio.aws.appstream.model.AccessEndpoint.ReadOnly
    ]] = AwsError.unwrapOptionField("accessEndpoints", accessEndpoints)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appstream.model.ImageBuilder
  ) extends zio.aws.appstream.model.ImageBuilder.ReadOnly {
    override val name: String = impl.name(): String
    override val arn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.appstream.model.primitives.Arn(value))
    override val imageArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.imageArn())
      .map(value => zio.aws.appstream.model.primitives.Arn(value))
    override val description: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => value: String)
    override val displayName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.displayName())
      .map(value => value: String)
    override val vpcConfig
        : Optional[zio.aws.appstream.model.VpcConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vpcConfig())
        .map(value => zio.aws.appstream.model.VpcConfig.wrap(value))
    override val instanceType: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.instanceType())
      .map(value => value: String)
    override val platform: Optional[zio.aws.appstream.model.PlatformType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.platform())
        .map(value => zio.aws.appstream.model.PlatformType.wrap(value))
    override val iamRoleArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.iamRoleArn())
      .map(value => zio.aws.appstream.model.primitives.Arn(value))
    override val state: Optional[zio.aws.appstream.model.ImageBuilderState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value => zio.aws.appstream.model.ImageBuilderState.wrap(value))
    override val stateChangeReason: Optional[
      zio.aws.appstream.model.ImageBuilderStateChangeReason.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.stateChangeReason())
      .map(value =>
        zio.aws.appstream.model.ImageBuilderStateChangeReason.wrap(value)
      )
    override val createdTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.createdTime())
      .map(value => zio.aws.appstream.model.primitives.Timestamp(value))
    override val enableDefaultInternetAccess: Optional[BooleanObject] =
      zio.aws.core.internal
        .optionalFromNullable(impl.enableDefaultInternetAccess())
        .map(value => value: BooleanObject)
    override val domainJoinInfo
        : Optional[zio.aws.appstream.model.DomainJoinInfo.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.domainJoinInfo())
        .map(value => zio.aws.appstream.model.DomainJoinInfo.wrap(value))
    override val networkAccessConfiguration: Optional[
      zio.aws.appstream.model.NetworkAccessConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.networkAccessConfiguration())
      .map(value =>
        zio.aws.appstream.model.NetworkAccessConfiguration.wrap(value)
      )
    override val imageBuilderErrors
        : Optional[List[zio.aws.appstream.model.ResourceError.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.imageBuilderErrors())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.appstream.model.ResourceError.wrap(item)
          }.toList
        )
    override val appstreamAgentVersion: Optional[AppstreamAgentVersion] =
      zio.aws.core.internal
        .optionalFromNullable(impl.appstreamAgentVersion())
        .map(value =>
          zio.aws.appstream.model.primitives.AppstreamAgentVersion(value)
        )
    override val accessEndpoints
        : Optional[List[zio.aws.appstream.model.AccessEndpoint.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.accessEndpoints())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.appstream.model.AccessEndpoint.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.appstream.model.ImageBuilder
  ): zio.aws.appstream.model.ImageBuilder.ReadOnly = new Wrapper(impl)
}
