package zio.aws.appstream.model
import zio.ZIO
import zio.aws.appstream.model.primitives.Name
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class AssociateApplicationToEntitlementRequest(
    stackName: Name,
    entitlementName: Name,
    applicationIdentifier: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appstream.model.AssociateApplicationToEntitlementRequest = {
    import AssociateApplicationToEntitlementRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appstream.model.AssociateApplicationToEntitlementRequest
      .builder()
      .stackName(Name.unwrap(stackName): java.lang.String)
      .entitlementName(Name.unwrap(entitlementName): java.lang.String)
      .applicationIdentifier(applicationIdentifier: java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.appstream.model.AssociateApplicationToEntitlementRequest.ReadOnly =
    zio.aws.appstream.model.AssociateApplicationToEntitlementRequest
      .wrap(buildAwsValue())
}
object AssociateApplicationToEntitlementRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appstream.model.AssociateApplicationToEntitlementRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.appstream.model.AssociateApplicationToEntitlementRequest =
      zio.aws.appstream.model.AssociateApplicationToEntitlementRequest(
        stackName,
        entitlementName,
        applicationIdentifier
      )
    def stackName: Name
    def entitlementName: Name
    def applicationIdentifier: String
    def getStackName: ZIO[Any, Nothing, Name] = ZIO.succeed(stackName)
    def getEntitlementName: ZIO[Any, Nothing, Name] =
      ZIO.succeed(entitlementName)
    def getApplicationIdentifier: ZIO[Any, Nothing, String] =
      ZIO.succeed(applicationIdentifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appstream.model.AssociateApplicationToEntitlementRequest
  ) extends zio.aws.appstream.model.AssociateApplicationToEntitlementRequest.ReadOnly {
    override val stackName: Name =
      zio.aws.appstream.model.primitives.Name(impl.stackName())
    override val entitlementName: Name =
      zio.aws.appstream.model.primitives.Name(impl.entitlementName())
    override val applicationIdentifier: String =
      impl.applicationIdentifier(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.appstream.model.AssociateApplicationToEntitlementRequest
  ): zio.aws.appstream.model.AssociateApplicationToEntitlementRequest.ReadOnly =
    new Wrapper(impl)
}
