package zio.aws.appstream.model
import zio.ZIO
import zio.aws.appstream.model.primitives.{Arn, Description, DisplayName, Name}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateApplicationRequest(
    name: Name,
    displayName: Optional[DisplayName] = Optional.Absent,
    description: Optional[Description] = Optional.Absent,
    iconS3Location: Optional[zio.aws.appstream.model.S3Location] =
      Optional.Absent,
    launchPath: Optional[String] = Optional.Absent,
    workingDirectory: Optional[String] = Optional.Absent,
    launchParameters: Optional[String] = Optional.Absent,
    appBlockArn: Optional[Arn] = Optional.Absent,
    attributesToDelete: Optional[
      Iterable[zio.aws.appstream.model.ApplicationAttribute]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appstream.model.UpdateApplicationRequest = {
    import UpdateApplicationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appstream.model.UpdateApplicationRequest
      .builder()
      .name(Name.unwrap(name): java.lang.String)
      .optionallyWith(
        displayName.map(value => DisplayName.unwrap(value): java.lang.String)
      )(_.displayName)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(iconS3Location.map(value => value.buildAwsValue()))(
        _.iconS3Location
      )
      .optionallyWith(launchPath.map(value => value: java.lang.String))(
        _.launchPath
      )
      .optionallyWith(workingDirectory.map(value => value: java.lang.String))(
        _.workingDirectory
      )
      .optionallyWith(launchParameters.map(value => value: java.lang.String))(
        _.launchParameters
      )
      .optionallyWith(
        appBlockArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.appBlockArn)
      .optionallyWith(
        attributesToDelete.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.attributesToDeleteWithStrings)
      .build()
  }
  def asReadOnly: zio.aws.appstream.model.UpdateApplicationRequest.ReadOnly =
    zio.aws.appstream.model.UpdateApplicationRequest.wrap(buildAwsValue())
}
object UpdateApplicationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appstream.model.UpdateApplicationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appstream.model.UpdateApplicationRequest =
      zio.aws.appstream.model.UpdateApplicationRequest(
        name,
        displayName.map(value => value),
        description.map(value => value),
        iconS3Location.map(value => value.asEditable),
        launchPath.map(value => value),
        workingDirectory.map(value => value),
        launchParameters.map(value => value),
        appBlockArn.map(value => value),
        attributesToDelete.map(value => value)
      )
    def name: Name
    def displayName: Optional[DisplayName]
    def description: Optional[Description]
    def iconS3Location: Optional[zio.aws.appstream.model.S3Location.ReadOnly]
    def launchPath: Optional[String]
    def workingDirectory: Optional[String]
    def launchParameters: Optional[String]
    def appBlockArn: Optional[Arn]
    def attributesToDelete
        : Optional[List[zio.aws.appstream.model.ApplicationAttribute]]
    def getName: ZIO[Any, Nothing, Name] = ZIO.succeed(name)
    def getDisplayName: ZIO[Any, AwsError, DisplayName] =
      AwsError.unwrapOptionField("displayName", displayName)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getIconS3Location
        : ZIO[Any, AwsError, zio.aws.appstream.model.S3Location.ReadOnly] =
      AwsError.unwrapOptionField("iconS3Location", iconS3Location)
    def getLaunchPath: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("launchPath", launchPath)
    def getWorkingDirectory: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("workingDirectory", workingDirectory)
    def getLaunchParameters: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("launchParameters", launchParameters)
    def getAppBlockArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("appBlockArn", appBlockArn)
    def getAttributesToDelete: ZIO[Any, AwsError, List[
      zio.aws.appstream.model.ApplicationAttribute
    ]] = AwsError.unwrapOptionField("attributesToDelete", attributesToDelete)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appstream.model.UpdateApplicationRequest
  ) extends zio.aws.appstream.model.UpdateApplicationRequest.ReadOnly {
    override val name: Name =
      zio.aws.appstream.model.primitives.Name(impl.name())
    override val displayName: Optional[DisplayName] = zio.aws.core.internal
      .optionalFromNullable(impl.displayName())
      .map(value => zio.aws.appstream.model.primitives.DisplayName(value))
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.appstream.model.primitives.Description(value))
    override val iconS3Location
        : Optional[zio.aws.appstream.model.S3Location.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.iconS3Location())
        .map(value => zio.aws.appstream.model.S3Location.wrap(value))
    override val launchPath: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.launchPath())
      .map(value => value: String)
    override val workingDirectory: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.workingDirectory())
      .map(value => value: String)
    override val launchParameters: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.launchParameters())
      .map(value => value: String)
    override val appBlockArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.appBlockArn())
      .map(value => zio.aws.appstream.model.primitives.Arn(value))
    override val attributesToDelete
        : Optional[List[zio.aws.appstream.model.ApplicationAttribute]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.attributesToDelete())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.appstream.model.ApplicationAttribute.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.appstream.model.UpdateApplicationRequest
  ): zio.aws.appstream.model.UpdateApplicationRequest.ReadOnly = new Wrapper(
    impl
  )
}
