package zio.aws.appstream.model
import zio.ZIO
import zio.aws.appstream.model.primitives.{Domain, ResourceIdentifier}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class StorageConnector(
    connectorType: zio.aws.appstream.model.StorageConnectorType,
    resourceIdentifier: Optional[ResourceIdentifier] = Optional.Absent,
    domains: Optional[Iterable[Domain]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appstream.model.StorageConnector = {
    import StorageConnector.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appstream.model.StorageConnector
      .builder()
      .connectorType(connectorType.unwrap)
      .optionallyWith(
        resourceIdentifier.map(value =>
          ResourceIdentifier.unwrap(value): java.lang.String
        )
      )(_.resourceIdentifier)
      .optionallyWith(
        domains.map(value =>
          value.map { item =>
            Domain.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.domains)
      .build()
  }
  def asReadOnly: zio.aws.appstream.model.StorageConnector.ReadOnly =
    zio.aws.appstream.model.StorageConnector.wrap(buildAwsValue())
}
object StorageConnector {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appstream.model.StorageConnector
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appstream.model.StorageConnector =
      zio.aws.appstream.model.StorageConnector(
        connectorType,
        resourceIdentifier.map(value => value),
        domains.map(value => value)
      )
    def connectorType: zio.aws.appstream.model.StorageConnectorType
    def resourceIdentifier: Optional[ResourceIdentifier]
    def domains: Optional[List[Domain]]
    def getConnectorType
        : ZIO[Any, Nothing, zio.aws.appstream.model.StorageConnectorType] =
      ZIO.succeed(connectorType)
    def getResourceIdentifier: ZIO[Any, AwsError, ResourceIdentifier] =
      AwsError.unwrapOptionField("resourceIdentifier", resourceIdentifier)
    def getDomains: ZIO[Any, AwsError, List[Domain]] =
      AwsError.unwrapOptionField("domains", domains)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appstream.model.StorageConnector
  ) extends zio.aws.appstream.model.StorageConnector.ReadOnly {
    override val connectorType: zio.aws.appstream.model.StorageConnectorType =
      zio.aws.appstream.model.StorageConnectorType.wrap(impl.connectorType())
    override val resourceIdentifier: Optional[ResourceIdentifier] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceIdentifier())
        .map(value =>
          zio.aws.appstream.model.primitives.ResourceIdentifier(value)
        )
    override val domains: Optional[List[Domain]] = zio.aws.core.internal
      .optionalFromNullable(impl.domains())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.appstream.model.primitives.Domain(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.appstream.model.StorageConnector
  ): zio.aws.appstream.model.StorageConnector.ReadOnly = new Wrapper(impl)
}
