package zio.aws.appstream.model
import zio.ZIO
import zio.aws.appstream.model.primitives.Name
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class StopAppBlockBuilderRequest(name: Name) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appstream.model.StopAppBlockBuilderRequest = {
    import StopAppBlockBuilderRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appstream.model.StopAppBlockBuilderRequest
      .builder()
      .name(Name.unwrap(name): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.appstream.model.StopAppBlockBuilderRequest.ReadOnly =
    zio.aws.appstream.model.StopAppBlockBuilderRequest.wrap(buildAwsValue())
}
object StopAppBlockBuilderRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appstream.model.StopAppBlockBuilderRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appstream.model.StopAppBlockBuilderRequest =
      zio.aws.appstream.model.StopAppBlockBuilderRequest(name)
    def name: Name
    def getName: ZIO[Any, Nothing, Name] = ZIO.succeed(name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appstream.model.StopAppBlockBuilderRequest
  ) extends zio.aws.appstream.model.StopAppBlockBuilderRequest.ReadOnly {
    override val name: Name =
      zio.aws.appstream.model.primitives.Name(impl.name())
  }
  def wrap(
      impl: software.amazon.awssdk.services.appstream.model.StopAppBlockBuilderRequest
  ): zio.aws.appstream.model.StopAppBlockBuilderRequest.ReadOnly = new Wrapper(
    impl
  )
}
