package zio.aws.appstream.model
import scala.jdk.CollectionConverters._
sealed trait PreferredProtocol {
  def unwrap: software.amazon.awssdk.services.appstream.model.PreferredProtocol
}
object PreferredProtocol {
  def wrap(
      value: software.amazon.awssdk.services.appstream.model.PreferredProtocol
  ): zio.aws.appstream.model.PreferredProtocol = value match {
    case software.amazon.awssdk.services.appstream.model.PreferredProtocol.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.appstream.model.PreferredProtocol.TCP =>
      val r = TCP
      r
    case software.amazon.awssdk.services.appstream.model.PreferredProtocol.UDP =>
      val r = UDP
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.appstream.model.PreferredProtocol {
    override def unwrap
        : software.amazon.awssdk.services.appstream.model.PreferredProtocol =
      software.amazon.awssdk.services.appstream.model.PreferredProtocol.UNKNOWN_TO_SDK_VERSION
  }
  case object TCP extends zio.aws.appstream.model.PreferredProtocol {
    override def unwrap
        : software.amazon.awssdk.services.appstream.model.PreferredProtocol =
      software.amazon.awssdk.services.appstream.model.PreferredProtocol.TCP
  }
  case object UDP extends zio.aws.appstream.model.PreferredProtocol {
    override def unwrap
        : software.amazon.awssdk.services.appstream.model.PreferredProtocol =
      software.amazon.awssdk.services.appstream.model.PreferredProtocol.UDP
  }
}
