package zio.aws.appstream.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListEntitledApplicationsResponse(
    entitledApplications: Optional[
      Iterable[zio.aws.appstream.model.EntitledApplication]
    ] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appstream.model.ListEntitledApplicationsResponse = {
    import ListEntitledApplicationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appstream.model.ListEntitledApplicationsResponse
      .builder()
      .optionallyWith(
        entitledApplications.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.entitledApplications)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.appstream.model.ListEntitledApplicationsResponse.ReadOnly =
    zio.aws.appstream.model.ListEntitledApplicationsResponse
      .wrap(buildAwsValue())
}
object ListEntitledApplicationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appstream.model.ListEntitledApplicationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appstream.model.ListEntitledApplicationsResponse =
      zio.aws.appstream.model.ListEntitledApplicationsResponse(
        entitledApplications.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def entitledApplications
        : Optional[List[zio.aws.appstream.model.EntitledApplication.ReadOnly]]
    def nextToken: Optional[String]
    def getEntitledApplications: ZIO[Any, AwsError, List[
      zio.aws.appstream.model.EntitledApplication.ReadOnly
    ]] =
      AwsError.unwrapOptionField("entitledApplications", entitledApplications)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appstream.model.ListEntitledApplicationsResponse
  ) extends zio.aws.appstream.model.ListEntitledApplicationsResponse.ReadOnly {
    override val entitledApplications
        : Optional[List[zio.aws.appstream.model.EntitledApplication.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.entitledApplications())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.appstream.model.EntitledApplication.wrap(item)
          }.toList
        )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.appstream.model.ListEntitledApplicationsResponse
  ): zio.aws.appstream.model.ListEntitledApplicationsResponse.ReadOnly =
    new Wrapper(impl)
}
