package zio.aws.appstream.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class EntitlementAttribute(name: String, value: String) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appstream.model.EntitlementAttribute = {
    import EntitlementAttribute.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appstream.model.EntitlementAttribute
      .builder()
      .name(name: java.lang.String)
      .value(value: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.appstream.model.EntitlementAttribute.ReadOnly =
    zio.aws.appstream.model.EntitlementAttribute.wrap(buildAwsValue())
}
object EntitlementAttribute {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appstream.model.EntitlementAttribute
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appstream.model.EntitlementAttribute =
      zio.aws.appstream.model.EntitlementAttribute(name, value)
    def name: String
    def value: String
    def getName: ZIO[Any, Nothing, String] = ZIO.succeed(name)
    def getValue: ZIO[Any, Nothing, String] = ZIO.succeed(value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appstream.model.EntitlementAttribute
  ) extends zio.aws.appstream.model.EntitlementAttribute.ReadOnly {
    override val name: String = impl.name(): String
    override val value: String = impl.value(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.appstream.model.EntitlementAttribute
  ): zio.aws.appstream.model.EntitlementAttribute.ReadOnly = new Wrapper(impl)
}
