package zio.aws.appstream.model
import zio.ZIO
import zio.aws.appstream.model.primitives.{Name, Arn}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DisassociateAppBlockBuilderAppBlockRequest(
    appBlockArn: Arn,
    appBlockBuilderName: Name
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appstream.model.DisassociateAppBlockBuilderAppBlockRequest = {
    import DisassociateAppBlockBuilderAppBlockRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appstream.model.DisassociateAppBlockBuilderAppBlockRequest
      .builder()
      .appBlockArn(Arn.unwrap(appBlockArn): java.lang.String)
      .appBlockBuilderName(Name.unwrap(appBlockBuilderName): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.appstream.model.DisassociateAppBlockBuilderAppBlockRequest.ReadOnly =
    zio.aws.appstream.model.DisassociateAppBlockBuilderAppBlockRequest
      .wrap(buildAwsValue())
}
object DisassociateAppBlockBuilderAppBlockRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appstream.model.DisassociateAppBlockBuilderAppBlockRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.appstream.model.DisassociateAppBlockBuilderAppBlockRequest =
      zio.aws.appstream.model.DisassociateAppBlockBuilderAppBlockRequest(
        appBlockArn,
        appBlockBuilderName
      )
    def appBlockArn: Arn
    def appBlockBuilderName: Name
    def getAppBlockArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(appBlockArn)
    def getAppBlockBuilderName: ZIO[Any, Nothing, Name] =
      ZIO.succeed(appBlockBuilderName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appstream.model.DisassociateAppBlockBuilderAppBlockRequest
  ) extends zio.aws.appstream.model.DisassociateAppBlockBuilderAppBlockRequest.ReadOnly {
    override val appBlockArn: Arn =
      zio.aws.appstream.model.primitives.Arn(impl.appBlockArn())
    override val appBlockBuilderName: Name =
      zio.aws.appstream.model.primitives.Name(impl.appBlockBuilderName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.appstream.model.DisassociateAppBlockBuilderAppBlockRequest
  ): zio.aws.appstream.model.DisassociateAppBlockBuilderAppBlockRequest.ReadOnly =
    new Wrapper(impl)
}
