package zio.aws.appstream.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeFleetsResponse(
    fleets: Optional[Iterable[zio.aws.appstream.model.Fleet]] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appstream.model.DescribeFleetsResponse = {
    import DescribeFleetsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appstream.model.DescribeFleetsResponse
      .builder()
      .optionallyWith(
        fleets.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.fleets)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.appstream.model.DescribeFleetsResponse.ReadOnly =
    zio.aws.appstream.model.DescribeFleetsResponse.wrap(buildAwsValue())
}
object DescribeFleetsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appstream.model.DescribeFleetsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appstream.model.DescribeFleetsResponse =
      zio.aws.appstream.model.DescribeFleetsResponse(
        fleets.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def fleets: Optional[List[zio.aws.appstream.model.Fleet.ReadOnly]]
    def nextToken: Optional[String]
    def getFleets
        : ZIO[Any, AwsError, List[zio.aws.appstream.model.Fleet.ReadOnly]] =
      AwsError.unwrapOptionField("fleets", fleets)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appstream.model.DescribeFleetsResponse
  ) extends zio.aws.appstream.model.DescribeFleetsResponse.ReadOnly {
    override val fleets
        : Optional[List[zio.aws.appstream.model.Fleet.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.fleets())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.appstream.model.Fleet.wrap(item)
          }.toList
        )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.appstream.model.DescribeFleetsResponse
  ): zio.aws.appstream.model.DescribeFleetsResponse.ReadOnly = new Wrapper(impl)
}
